/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothService;
import java.util.HashMap;
import java.util.Map;

public class BluetoothDatabase {
    private final Map<BluetoothService, Short> services = new HashMap<BluetoothService, Short>();
    private final Map<BluetoothAttribute, Short> attributes = new HashMap<BluetoothAttribute, Short>();

    public void clear() {
        this.services.clear();
        this.attributes.clear();
    }

    @Nullable
    public Short getServiceHandle(BluetoothService service) {
        return this.services.get(service);
    }

    @Nullable
    public Short getAttributeHandle(BluetoothAttribute attribute) {
        return this.attributes.get(attribute);
    }

    @Nullable
    public BluetoothAttribute getAttribute(short attributeHandle) {
        for (Map.Entry<BluetoothAttribute, Short> entry : this.attributes.entrySet()) {
            Short handle = entry.getValue();
            assert (handle != null);
            if (handle != attributeHandle) continue;
            return entry.getKey();
        }
        return null;
    }

    public short addService(BluetoothService service, short counter, @Nullable short[] handles) {
        int handleIndex = 0;
        short serviceHandle = counter;
        counter = (short)(counter + 1);
        if (handles != null) {
            handles[handleIndex] = serviceHandle;
            ++handleIndex;
        }
        this.services.put(service, serviceHandle);
        int numCharacteristics = service.getNumCharacteristics();
        int c = 0;
        while (c < numCharacteristics) {
            BluetoothCharacteristic characteristic = service.getCharacteristic(c);
            short characteristicHandle = counter;
            counter = (short)(counter + 1);
            if (handles != null) {
                handles[handleIndex] = characteristicHandle;
                ++handleIndex;
            }
            this.attributes.put((BluetoothAttribute)characteristic, characteristicHandle);
            int numDescriptors = characteristic.getNumDescriptors();
            int d = 0;
            while (d < numDescriptors) {
                BluetoothDescriptor descriptor = characteristic.getDescriptor(d);
                short descriptorHandle = counter;
                counter = (short)(counter + 1);
                if (handles != null) {
                    handles[handleIndex] = descriptorHandle;
                    ++handleIndex;
                }
                this.attributes.put((BluetoothAttribute)descriptor, descriptorHandle);
                ++d;
            }
            ++c;
        }
        return counter;
    }
}

