/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.MouseListener;
import ej.fp.Widget;
import ej.fp.util.WidgetWithListener;
import ej.microui.event.EventCommand;

@Widget.WidgetDescription(attributes={@Widget.WidgetAttribute(name="label", isOptional=true), @Widget.WidgetAttribute(name="x"), @Widget.WidgetAttribute(name="y"), @Widget.WidgetAttribute(name="maxAngle"), @Widget.WidgetAttribute(name="steps"), @Widget.WidgetAttribute(name="pushedSkin"), @Widget.WidgetAttribute(name="filter", isOptional=true), @Widget.WidgetAttribute(name="listenerClass", isOptional=true)})
public class Wheel
extends WidgetWithListener
implements MouseListener {
    private WheelListener listener;
    private Image[] steps;
    private Image pushedSkin;
    private int xCenter;
    private int yCenter;
    private double lastAngle;
    private double maxAngle;
    private double stepAngle;
    private int current;
    private boolean unending;

    public void setPushedSkin(Image pushedSkin) {
        this.pushedSkin = pushedSkin;
    }

    public void setMaxAngle(double maxAngle) {
        if (maxAngle < 0.0) {
            throw new IllegalArgumentException("Angle cannot be negative.");
        }
        this.maxAngle = maxAngle * Math.PI / 180.0;
    }

    public void setSteps(Image[] steps) {
        this.steps = steps;
        this.setSkin(steps[0]);
    }

    public void setListenerClass(String listenerClassName) {
        this.setListenerClass(WheelListener.class, listenerClassName);
    }

    public synchronized void finalizeConfiguration() {
        super.finalizeConfiguration();
        this.current = 0;
        this.xCenter = this.getWidth() >> 1;
        this.yCenter = this.getHeight() >> 1;
        this.unending = this.maxAngle == 0.0;
        this.stepAngle = this.unending ? Math.PI * 2 / (double)this.steps.length : this.maxAngle / (double)this.steps.length;
    }

    public void start() {
        super.start();
        this.listener = this.newListener(WheelListener.class);
    }

    @Override
    protected Object newDefaultListener() {
        return new WheelListenerToCommandEvents();
    }

    public void mousePressed(int x, int y, MouseListener.MouseButton button) {
        if (button == MouseListener.MouseButton.THIRD_BUTTON) {
            double opp = this.yCenter - y;
            double adj = this.xCenter - x;
            this.lastAngle = Math.atan2(opp, adj);
            this.press();
        }
    }

    public void mouseDragged(int x, int y) {
        double opp = this.yCenter - y;
        double adj = this.xCenter - x;
        double angle = Math.atan2(opp, adj);
        double shift = this.lastAngle - angle;
        if (shift > Math.PI) {
            shift += Math.PI * -2;
        }
        if (shift < -Math.PI) {
            shift = Math.PI * 2 - shift;
        }
        if (shift > this.stepAngle) {
            if (this.turnBackward()) {
                this.lastAngle = angle;
            }
        } else if (shift < -this.stepAngle && this.turnForward()) {
            this.lastAngle = angle;
        }
    }

    public void mouseReleased(int x, int y, MouseListener.MouseButton button) {
        if (button == MouseListener.MouseButton.THIRD_BUTTON) {
            this.release();
        }
    }

    private boolean turnForward() {
        int old = this.current;
        int length = this.steps.length;
        this.current = old + 1;
        if (this.current >= length - 1) {
            this.current = this.unending ? (this.current %= length) : length - 1;
        }
        if (old != this.current) {
            this.setCurrentSkin(this.steps[this.current]);
            this.listener.turnForward(this, this.current);
            return true;
        }
        return false;
    }

    private boolean turnBackward() {
        int old = this.current;
        int length = this.steps.length;
        this.current = old - 1;
        if (this.current < 0) {
            this.current = this.unending ? this.current % length + length : 0;
        }
        if (old != this.current) {
            this.setCurrentSkin(this.steps[this.current]);
            this.listener.turnBackward(this, this.current);
            return true;
        }
        return false;
    }

    private void press() {
        this.setCurrentSkin(this.pushedSkin);
        this.listener.press(this);
    }

    private void release() {
        this.setCurrentSkin(this.steps[this.current]);
        this.listener.release(this);
    }

    public void dispose() {
        FrontPanel.getFrontPanel().disposeIfNotNull(this.steps);
        this.steps = null;
        super.dispose();
    }

    public static interface WheelListener {
        public void press(Wheel var1);

        public void release(Wheel var1);

        public void turnForward(Wheel var1, int var2);

        public void turnBackward(Wheel var1, int var2);
    }

    public static class WheelListenerToCommandEvents
    implements WheelListener {
        @Override
        public void turnForward(Wheel widget, int step) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)18);
        }

        @Override
        public void turnBackward(Wheel widget, int step) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)19);
        }

        @Override
        public void press(Wheel widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)6);
        }

        @Override
        public void release(Wheel widget) {
        }

        protected String getMicroUIGeneratorTag() {
            return "COMMANDS";
        }
    }
}

