/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketPermission;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import sun.net.NetworkClient;
import sun.net.www.MessageHeader;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.HttpURLConnection;

public class HttpClient
extends NetworkClient {
    MessageHeader requests;
    PosterOutputStream poster = null;
    boolean streaming;
    boolean failedOnce = false;
    private boolean ignoreContinue = true;
    private static final int HTTP_CONTINUE = 100;
    static final int httpPortNumber = 80;
    protected String host;
    protected int port;
    private static boolean retryPostProp = true;
    protected URL url;
    public boolean reuse = false;
    public static final String SOCKET_RESOLVE_ACTION = "resolve";
    public static final String SOCKET_CONNECT_ACTION = "connect";

    static {
        String retryPost = System.getProperty("sun.net.http.retryPost");
        retryPostProp = retryPost != null ? Boolean.valueOf(retryPost) : true;
    }

    protected int getDefaultPort() {
        return 80;
    }

    @Deprecated
    public static synchronized void resetProperties() {
    }

    protected HttpClient() {
    }

    protected HttpClient(URL url, int to) throws IOException {
        this.host = url.getHost();
        this.url = url;
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setConnectTimeout(to);
        this.openServer();
    }

    public static HttpClient New(URL url) throws IOException {
        return HttpClient.New(url, -1, null);
    }

    public static HttpClient New(URL url, int to, HttpURLConnection httpuc) throws IOException {
        HttpClient ret = new HttpClient(url, to);
        return ret;
    }

    public void finished() {
        if (this.reuse) {
            return;
        }
        this.poster = null;
        this.closeServer();
    }

    protected synchronized boolean available() {
        boolean available = true;
        int old = -1;
        try {
            try {
                try {
                    old = this.serverSocket.getSoTimeout();
                    this.serverSocket.setSoTimeout(1);
                    BufferedInputStream tmpbuf = new BufferedInputStream(this.serverSocket.getInputStream());
                    int r = tmpbuf.read();
                    if (r == -1) {
                        available = false;
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (old != -1) {
                        this.serverSocket.setSoTimeout(old);
                    }
                }
            }
            finally {
                if (old != -1) {
                    this.serverSocket.setSoTimeout(old);
                }
            }
        }
        catch (IOException iOException) {
            available = false;
        }
        return available;
    }

    public void closeIdleConnection() {
    }

    @Override
    public void openServer(String server, int port) throws IOException {
        this.serverSocket = this.doConnect(server, port);
        try {
            OutputStream out = this.serverSocket.getOutputStream();
            this.serverOutput = new PrintStream((OutputStream)new BufferedOutputStream(out), false, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(String.valueOf(encoding) + " encoding not found");
        }
    }

    protected synchronized void openServer() throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            HttpClient.checkConnect(security, this.host, this.port);
        }
        if (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https")) {
            this.openServer(this.host, this.port);
            return;
        }
        super.openServer(this.host, this.port);
    }

    public String getURLFile() throws IOException {
        String fileName = this.url.getFile();
        if (fileName == null || fileName.length() == 0) {
            fileName = "/";
        }
        if (fileName.indexOf(10) == -1) {
            return fileName;
        }
        throw new MalformedURLException("Illegal character in URL");
    }

    @Deprecated
    public void writeRequests(MessageHeader head) {
        this.requests = head;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public void writeRequests(MessageHeader head, PosterOutputStream pos) throws IOException {
        this.requests = head;
        this.requests.print(this.serverOutput);
        this.poster = pos;
        if (this.poster != null) {
            this.poster.writeTo(this.serverOutput);
        }
        this.serverOutput.flush();
    }

    public void writeRequests(MessageHeader head, PosterOutputStream pos, boolean streaming) throws IOException {
        this.streaming = streaming;
        this.writeRequests(head, pos);
    }

    public boolean parseHTTP(MessageHeader responses, HttpURLConnection httpuc) throws IOException {
        try {
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            return this.parseHTTPHeader(responses, httpuc);
        }
        catch (SocketTimeoutException stex) {
            if (this.ignoreContinue) {
                this.closeServer();
            }
            throw stex;
        }
        catch (IOException e) {
            this.closeServer();
            if (!this.failedOnce && this.requests != null) {
                this.failedOnce = true;
                if (!this.getRequestMethod().equals("CONNECT") && (!httpuc.getRequestMethod().equals("POST") || retryPostProp && !this.streaming)) {
                    this.openServer();
                    this.writeRequests(this.requests, this.poster);
                    return this.parseHTTP(responses, httpuc);
                }
            }
            throw e;
        }
    }

    private boolean parseHTTPHeader(MessageHeader responses, HttpURLConnection httpuc) throws IOException {
        boolean ret = false;
        byte[] b = new byte[8];
        int nread = 0;
        this.serverInput.mark(10);
        while (nread < 8) {
            int r = this.serverInput.read(b, nread, 8 - nread);
            if (r < 0) break;
            nread += r;
        }
        ret = b[0] == 72 && b[1] == 84 && b[2] == 84 && b[3] == 80 && b[4] == 47 && b[5] == 49 && b[6] == 46;
        this.serverInput.reset();
        if (ret) {
            responses.parseHeader(this.serverInput);
        } else {
            if (nread != 8) {
                if (!this.failedOnce && this.requests != null) {
                    this.failedOnce = true;
                    if (!this.getRequestMethod().equals("CONNECT") && (!httpuc.getRequestMethod().equals("POST") || retryPostProp && !this.streaming)) {
                        this.closeServer();
                        this.openServer();
                        this.writeRequests(this.requests, this.poster);
                        return this.parseHTTP(responses, httpuc);
                    }
                }
                throw new SocketException("Unexpected end of file from server");
            }
            responses.set("Content-type", "unknown/unknown");
        }
        int code = -1;
        try {
            String resp = responses.getValue(0);
            int ind = resp.indexOf(32);
            while (resp.charAt(ind) == ' ') {
                ++ind;
            }
            code = Integer.parseInt(resp.substring(ind, ind + 3));
        }
        catch (Exception exception) {}
        if (code == 100 && this.ignoreContinue) {
            responses.reset();
            return this.parseHTTPHeader(responses, httpuc);
        }
        String te = responses.findValue("Transfer-Encoding");
        if (te != null && te.equalsIgnoreCase("chunked")) {
            this.serverInput = new ChunkedInputStream(this.serverInput, this, responses);
            this.failedOnce = false;
        }
        return ret;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.url + ")";
    }

    String getRequestMethod() {
        String requestLine;
        if (this.requests != null && (requestLine = this.requests.getKey(0)) != null) {
            return HttpClient.splitWhitespace(requestLine)[0];
        }
        return "";
    }

    public static String[] splitWhitespace(String str) {
        ArrayList<String> result = new ArrayList<String>();
        int length = str.length();
        StringBuilder current = new StringBuilder();
        int i = -1;
        while (++i < length) {
            char c = str.charAt(i);
            if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r') {
                if (current.length() <= 0) continue;
                result.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            result.add(current.toString());
            current = new StringBuilder();
        }
        return result.toArray(new String[result.size()]);
    }

    public void setDoNotRetry(boolean value) {
        this.failedOnce = value;
    }

    public void setIgnoreContinue(boolean value) {
        this.ignoreContinue = value;
    }

    @Override
    public void closeServer() {
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {}
    }

    public static void checkConnect(SecurityManager sm, String host, int port) {
        if (host == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!host.startsWith("[") && host.indexOf(58) != -1) {
            host = "[" + host + "]";
        }
        if (port == -1) {
            sm.checkPermission(new SocketPermission(host, SOCKET_RESOLVE_ACTION));
        } else {
            sm.checkPermission(new SocketPermission(String.valueOf(host) + ":" + port, SOCKET_CONNECT_ACTION));
        }
    }
}

