/*
 * Decompiled with CFR 0.152.
 */
package ej.drawing;

import ej.microui.Log;
import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIFont;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImage;
import ej.microui.display.MicroUIRenderableString;

public class LLDWPainter {
    private LLDWPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedPoint(byte[] target, int x, int y, int thickness, int fade) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(110, Log.mapGraphicsContext(gc), x, y, thickness, fade);
                if (thickness > 0 || fade > 0) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedPoint(gc, x, y, thickness, fade);
                }
                Log.recordEventEnd(110, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedLine(byte[] target, int x1, int y1, int x2, int y2, int thickness, int fade, int start, int end) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(111, Log.mapGraphicsContext(gc), x1, y1, x2, y2, thickness, fade);
                if (thickness > 0 || fade > 0) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedLine(gc, x1, y1, x2, y2, thickness, fade, LLDWPainter.mapCap(start), LLDWPainter.mapCap(end));
                }
                Log.recordEventEnd(111, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedCircle(byte[] target, int x, int y, int diameter, int thickness, int fade) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(112, Log.mapGraphicsContext(gc), x, y, diameter, thickness, fade);
                if (diameter > 0 && (thickness > 0 || fade > 0)) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedCircle(gc, x, y, diameter, thickness, fade);
                }
                Log.recordEventEnd(112, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle, int thickness, int fade, int start, int end) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(113, Log.mapGraphicsContext(gc), x, y, diameter, (int)startAngle, (int)arcAngle, thickness, fade);
                if (diameter > 0 && arcAngle != 0.0f && (thickness > 0 || fade > 0)) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedCircleArc(gc, x, y, diameter, startAngle, arcAngle, thickness, fade, LLDWPainter.mapCap(start), LLDWPainter.mapCap(end));
                }
                Log.recordEventEnd(113, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedEllipse(byte[] target, int x, int y, int width, int height, int thickness, int fade) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(114, Log.mapGraphicsContext(gc), x, y, width, height, thickness, fade);
                if (width > 0 && height > 0 && (thickness > 0 || fade > 0)) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedEllipse(gc, x, y, width, height, thickness, fade);
                }
                Log.recordEventEnd(114, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickLine(byte[] target, int x1, int y1, int x2, int y2, int thickness) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(115, Log.mapGraphicsContext(gc), x1, y1, x2, y2, thickness);
                if (thickness > 0) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawThickLine(gc, x1, y1, x2, y2, thickness);
                }
                Log.recordEventEnd(115, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickEllipse(byte[] target, int x, int y, int width, int height, int thickness) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(117, Log.mapGraphicsContext(gc), x, y, width, height, thickness);
                if (width > 0 && height > 0 && thickness > 0) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawThickEllipse(gc, x, y, width, height, thickness);
                }
                Log.recordEventEnd(117, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickCircle(byte[] target, int x, int y, int diameter, int thickness) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(116, Log.mapGraphicsContext(gc), x, y, diameter, thickness);
                if (diameter > 0 && thickness > 0) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawThickCircle(gc, x, y, diameter, thickness);
                }
                Log.recordEventEnd(116, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle, int thickness) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(118, Log.mapGraphicsContext(gc), x, y, diameter, (int)startAngle, (int)arcAngle, thickness);
                if (diameter > 0 && arcAngle != 0.0f && thickness > 0) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawThickCircleArc(gc, x, y, diameter, startAngle, arcAngle, thickness);
                }
                Log.recordEventEnd(118, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawFlippedImage(byte[] target, byte[] source, int regionX, int regionY, int width, int height, int x, int y, int flip, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
                Log.recordEvent(130, Log.mapGraphicsContext(gc), Log.mapImage(image), regionX, regionY, width, height, x, y, flip, alpha);
                if (alpha > 0 && !image.isClosed()) {
                    DrawingFlip drawingFlip = LLDWPainter.mapFlip(flip);
                    LLUIDisplay.Instance.getUIDrawer(gc).drawFlippedImage(gc, image, regionX, regionY, width, height, x, y, drawingFlip, alpha);
                }
                Log.recordEventEnd(130, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRotatedImageNearestNeighbor(byte[] target, byte[] source, int x, int y, int rotationX, int rotationY, float angle, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
                Log.recordEvent(131, Log.mapGraphicsContext(gc), Log.mapImage(image), x, y, rotationX, rotationY, (int)angle, alpha, Log.mapApproximation(false));
                if (alpha > 0 && !image.isClosed()) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawRotatedImageNearestNeighbor(gc, image, x, y, rotationX, rotationY, angle, alpha);
                }
                Log.recordEventEnd(131, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRotatedImageBilinear(byte[] target, byte[] source, int x, int y, int rotationX, int rotationY, float angle, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
                Log.recordEvent(131, Log.mapGraphicsContext(gc), Log.mapImage(image), x, y, rotationX, rotationY, (int)angle, alpha, Log.mapApproximation(true));
                if (alpha > 0 && !image.isClosed()) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawRotatedImageBilinear(gc, image, x, y, rotationX, rotationY, angle, alpha);
                }
                Log.recordEventEnd(131, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawScaledImageNearestNeighbor(byte[] target, byte[] source, int x, int y, float factorX, float factorY, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
                Log.recordEvent(132, Log.mapGraphicsContext(gc), Log.mapImage(image), x, y, (int)factorX, (int)factorY, alpha, Log.mapApproximation(false));
                if (alpha > 0 && factorX > 0.0f && factorY > 0.0f && !image.isClosed()) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawScaledImageNearestNeighbor(gc, image, x, y, factorX, factorY, alpha);
                }
                Log.recordEventEnd(132, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawScaledImageBilinear(byte[] target, byte[] source, int x, int y, float factorX, float factorY, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
                Log.recordEvent(132, Log.mapGraphicsContext(gc), Log.mapImage(image), x, y, (int)factorX, (int)factorY, alpha, Log.mapApproximation(true));
                if (alpha > 0 && factorX > 0.0f && factorY > 0.0f && !image.isClosed()) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawScaledImageBilinear(gc, image, x, y, factorX, factorY, alpha);
                }
                Log.recordEventEnd(132, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCharWithRotationBilinear(byte[] sd, char c, byte[] fontData, int destX, int destY, int xRotation, int yRotation, float angle, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(sd);
            if (gc.requestDrawing()) {
                Log.recordEvent(135, Log.mapGraphicsContext(gc), c, destX, destY, xRotation, yRotation, (int)angle, alpha, Log.mapApproximation(true));
                if (alpha > 0) {
                    MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
                    LLUIDisplay.Instance.getUIDrawer(gc).drawCharWithRotationBilinear(gc, c, font, destX, destY, xRotation, yRotation, angle, alpha);
                }
                Log.recordEventEnd(135, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCharWithRotationNearestNeighbor(byte[] sd, char c, byte[] fontData, int destX, int destY, int xRotation, int yRotation, float angle, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(sd);
            if (gc.requestDrawing()) {
                Log.recordEvent(135, Log.mapGraphicsContext(gc), c, destX, destY, xRotation, yRotation, (int)angle, alpha, Log.mapApproximation(false));
                if (alpha > 0) {
                    MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
                    LLUIDisplay.Instance.getUIDrawer(gc).drawCharWithRotationNearestNeighbor(gc, c, font, destX, destY, xRotation, yRotation, angle, alpha);
                }
                Log.recordEventEnd(135, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawScaledStringBilinear(byte[] sd, char[] chars, int length, byte[] fontData, int x, int y, float xRatio, float yRatio) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(sd);
            if (gc.requestDrawing()) {
                Log.recordEvent(133, Log.mapGraphicsContext(gc), length, x, y, (int)xRatio, (int)yRatio, Log.mapApproximation(true));
                if (length > 0 && xRatio > 0.0f && yRatio > 0.0f) {
                    MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
                    char[] string = graphicsEngine.mapString(chars, 0, length);
                    LLUIDisplay.Instance.getUIDrawer(gc).drawScaledStringBilinear(gc, string, font, x, y, xRatio, yRatio);
                }
                Log.recordEventEnd(133, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawScaledRenderableStringBilinear(byte[] sd, char[] chars, int length, byte[] fontData, int charsWidth, byte[] renderableStringSNIContext, int x, int y, float xRatio, float yRatio) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(sd);
            if (gc.requestDrawing()) {
                Log.recordEvent(134, Log.mapGraphicsContext(gc), length, x, y, (int)xRatio, (int)yRatio, Log.mapApproximation(true));
                if (length > 0 && xRatio > 0.0f && yRatio > 0.0f) {
                    MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
                    char[] string = graphicsEngine.mapString(chars, 0, length);
                    MicroUIRenderableString renderableString = graphicsEngine.mapMicroUIRenderableString(renderableStringSNIContext);
                    LLUIDisplay.Instance.getUIDrawer(gc).drawScaledRenderableStringBilinear(gc, string, font, charsWidth, renderableString, x, y, xRatio, yRatio);
                }
                Log.recordEventEnd(134, 0);
            }
        }
    }

    private static DrawingCap mapCap(int value) {
        switch (value) {
            case 0: {
                return DrawingCap.DRAWING_ENDOFLINE_NONE;
            }
            case 1: {
                return DrawingCap.DRAWING_ENDOFLINE_ROUNDED;
            }
            case 2: {
                return DrawingCap.DRAWING_ENDOFLINE_PERPENDICULAR;
            }
        }
        throw new IllegalArgumentException();
    }

    private static DrawingFlip mapFlip(int value) {
        switch (value) {
            case 0: {
                return DrawingFlip.DRAWING_FLIP_NONE;
            }
            case 1: {
                return DrawingFlip.DRAWING_FLIP_MIRROR_90;
            }
            case 2: {
                return DrawingFlip.DRAWING_FLIP_270;
            }
            case 3: {
                return DrawingFlip.DRAWING_FLIP_MIRROR;
            }
            case 4: {
                return DrawingFlip.DRAWING_FLIP_180;
            }
            case 5: {
                return DrawingFlip.DRAWING_FLIP_MIRROR_270;
            }
            case 6: {
                return DrawingFlip.DRAWING_FLIP_MIRROR_180;
            }
            case 7: {
                return DrawingFlip.DRAWING_FLIP_90;
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum DrawingCap {
        DRAWING_ENDOFLINE_NONE(0),
        DRAWING_ENDOFLINE_ROUNDED(1),
        DRAWING_ENDOFLINE_PERPENDICULAR(2);

        public final int val;

        private DrawingCap(int val) {
            this.val = val;
        }
    }

    public static enum DrawingFlip {
        DRAWING_FLIP_NONE(0),
        DRAWING_FLIP_90(7),
        DRAWING_FLIP_180(4),
        DRAWING_FLIP_270(2),
        DRAWING_FLIP_MIRROR(3),
        DRAWING_FLIP_MIRROR_90(1),
        DRAWING_FLIP_MIRROR_180(6),
        DRAWING_FLIP_MIRROR_270(5);

        public final int val;

        private DrawingFlip(int val) {
            this.val = val;
        }
    }
}

