/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.impl;

import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.CommandSenderProvider;
import ej.rcommand.RemoteConnection;
import ej.rcommand.impl.AbstractRemoteService;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class CommandDispatchService
extends AbstractRemoteService {
    CommandDispatchService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commandReceived(CommandReader commandReader, CommandSender commandSender, String command) {
        this.getLogger().info("Dispatch command " + command);
        try {
            RemoteConnection remoteConnection = (RemoteConnection)commandReader;
            List<Object> params = remoteConnection.readParameters();
            assert (this.commandSenderProvider != null);
            CommandSenderProvider commandSenderProvider = this.commandSenderProvider;
            synchronized (commandSenderProvider) {
                for (CommandSender commandSender2 : this.commandSenderProvider.getCommandSenders(command)) {
                    if (commandSender2 == commandReader) continue;
                    RemoteConnection outputConnection = (RemoteConnection)commandSender2;
                    outputConnection.startCommand(command);
                    outputConnection.sendParams(params);
                    outputConnection.flushCommand();
                }
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private Logger getLogger() {
        Logger logger = Logger.getLogger(CommandDispatchService.class.getName());
        assert (logger != null);
        return logger;
    }

    @Override
    public String[] getManagedCommands() {
        return new String[0];
    }
}

