/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class Logger {
    public static final String GLOBAL_LOGGER_NAME = "global";
    protected Level effectiveLevel;
    protected Level publicLevel;
    private final String name;
    private Logger parent;
    private final List<Handler> handlers;

    protected Logger(String name, String resourceBundleName) {
        this.name = name;
        this.handlers = new ArrayList<Handler>();
        this.publicLevel = null;
        this.effectiveLevel = null;
    }

    public static Logger getAnonymousLogger() {
        Logger logger = new Logger(null, null);
        logger.setParent(LogManager.getLogManager().rootLogger);
        logger.setLevel(Level.ALL);
        return logger;
    }

    public static Logger getLogger(String name) {
        String lowerCaseName = name.toLowerCase();
        Logger logger = LogManager.getLogManager().getLogger(lowerCaseName);
        if (logger == null) {
            logger = new Logger(lowerCaseName, null);
            logger.setParent(LogManager.getLogManager().rootLogger);
            LogManager.getLogManager().addLogger(logger);
        }
        return logger;
    }

    public static final Logger getGlobal() {
        return Logger.getLogger(GLOBAL_LOGGER_NAME);
    }

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public Level getLevel() {
        return this.publicLevel;
    }

    public String getName() {
        return this.name;
    }

    public Logger getParent() {
        return this.parent;
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.effectiveLevel.intValue();
    }

    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    public void log(Level level, String msg, Throwable thrown) {
        LogRecord record = new LogRecord(level, msg);
        record.setThrown(thrown);
        this.log(record);
    }

    public void log(LogRecord record) {
        if (this.effectiveLevel.intValue() <= record.getLevel().intValue()) {
            if (record.getLoggerName() == null) {
                record.setLoggerName(this.name);
            }
            this.passToHandlers(record);
            if (this.parent != null) {
                this.parent.logFromChild(record);
            }
        }
    }

    private void logFromChild(LogRecord record) {
        this.passToHandlers(record);
        if (this.parent != null) {
            this.parent.logFromChild(record);
        }
    }

    private void passToHandlers(LogRecord record) {
        for (Handler handler : this.handlers) {
            handler.publish(record);
        }
    }

    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    public void setLevel(Level newLevel) {
        this.publicLevel = newLevel;
        this.updateLevel();
    }

    void setParent(Logger parent) {
        if (parent == null) {
            throw new NullPointerException("Parent cannot be null");
        }
        if (this != parent) {
            this.parent = parent;
            this.updateLevel();
        }
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.log(Level.FINER, String.valueOf(sourceClass) + "." + sourceMethod, thrown);
    }

    private void updateLevel() {
        if (this.publicLevel == null) {
            if (this.parent != null) {
                this.effectiveLevel = this.parent.getLevel();
            }
        } else {
            this.effectiveLevel = this.publicLevel;
        }
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }
}

