/*
 * Decompiled with CFR 0.152.
 */
package ej.drawing;

import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImage;

public class LLDWPainter {
    private LLDWPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedPoint(byte[] target, int x, int y, int thickness, int fade) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && (thickness > 0 || fade > 0)) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedPoint(gc, x, y, thickness, fade);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedLine(byte[] target, int x1, int y1, int x2, int y2, int thickness, int fade, int start, int end) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && (thickness > 0 || fade > 0)) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedLine(gc, x1, y1, x2, y2, thickness, fade, LLDWPainter.mapCap(start), LLDWPainter.mapCap(end));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedCircle(byte[] target, int x, int y, int diameter, int thickness, int fade) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0 && (thickness > 0 || fade > 0)) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedCircle(gc, x, y, diameter, thickness, fade);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle, int thickness, int fade, int start, int end) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0 && arcAngle != 0.0f && (thickness > 0 || fade > 0)) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedCircleArc(gc, x, y, diameter, startAngle, arcAngle, thickness, fade, LLDWPainter.mapCap(start), LLDWPainter.mapCap(end));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickFadedEllipse(byte[] target, int x, int y, int width, int height, int thickness, int fade) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0 && (thickness > 0 || fade > 0)) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawThickFadedEllipse(gc, x, y, width, height, thickness, fade);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickLine(byte[] target, int x1, int y1, int x2, int y2, int thickness) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && thickness > 0) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawThickLine(gc, x1, y1, x2, y2, thickness);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickEllipse(byte[] target, int x, int y, int width, int height, int thickness) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0 && thickness > 0) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawThickEllipse(gc, x, y, width, height, thickness);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickCircle(byte[] target, int x, int y, int diameter, int thickness) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0 && thickness > 0) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawThickCircle(gc, x, y, diameter, thickness);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThickCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle, int thickness) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0 && arcAngle != 0.0f && thickness > 0) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawThickCircleArc(gc, x, y, diameter, startAngle, arcAngle, thickness);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawFlippedImage(byte[] target, byte[] source, int regionX, int regionY, int width, int height, int x, int y, int flip, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
            if (gc.requestDrawing() && alpha > 0 && !image.isClosed()) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawFlippedImage(gc, image, regionX, regionY, width, height, x, y, LLDWPainter.mapFlip(flip), alpha);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRotatedImageNearestNeighbor(byte[] target, byte[] source, int x, int y, int rotationX, int rotationY, float angle, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
            if (gc.requestDrawing() && alpha > 0 && !image.isClosed()) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawRotatedImageNearestNeighbor(gc, image, x, y, rotationX, rotationY, angle, alpha);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRotatedImageBilinear(byte[] target, byte[] source, int x, int y, int rotationX, int rotationY, float angle, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
            if (gc.requestDrawing() && alpha > 0 && !image.isClosed()) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawRotatedImageBilinear(gc, image, x, y, rotationX, rotationY, angle, alpha);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawScaledImageNearestNeighbor(byte[] target, byte[] source, int x, int y, float factorX, float factorY, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
            if (gc.requestDrawing() && alpha > 0 && !image.isClosed()) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawScaledImageNearestNeighbor(gc, image, x, y, factorX, factorY, alpha);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawScaledImageBilinear(byte[] target, byte[] source, int x, int y, float factorX, float factorY, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
            if (gc.requestDrawing() && alpha > 0 && !image.isClosed()) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawScaledImageBilinear(gc, image, x, y, factorX, factorY, alpha);
            }
        }
    }

    private static DrawingCap mapCap(int value) {
        switch (value) {
            case 0: {
                return DrawingCap.DRAWING_ENDOFLINE_NONE;
            }
            case 1: {
                return DrawingCap.DRAWING_ENDOFLINE_ROUNDED;
            }
            case 2: {
                return DrawingCap.DRAWING_ENDOFLINE_PERPENDICULAR;
            }
        }
        throw new IllegalArgumentException();
    }

    private static DrawingFlip mapFlip(int value) {
        switch (value) {
            case 0: {
                return DrawingFlip.DRAWING_FLIP_NONE;
            }
            case 1: {
                return DrawingFlip.DRAWING_FLIP_MIRROR_90;
            }
            case 2: {
                return DrawingFlip.DRAWING_FLIP_270;
            }
            case 3: {
                return DrawingFlip.DRAWING_FLIP_MIRROR;
            }
            case 4: {
                return DrawingFlip.DRAWING_FLIP_180;
            }
            case 5: {
                return DrawingFlip.DRAWING_FLIP_MIRROR_270;
            }
            case 6: {
                return DrawingFlip.DRAWING_FLIP_MIRROR_180;
            }
            case 7: {
                return DrawingFlip.DRAWING_FLIP_90;
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum DrawingCap {
        DRAWING_ENDOFLINE_NONE(0),
        DRAWING_ENDOFLINE_ROUNDED(1),
        DRAWING_ENDOFLINE_PERPENDICULAR(2);

        public final int val;

        private DrawingCap(int val) {
            this.val = val;
        }
    }

    public static enum DrawingFlip {
        DRAWING_FLIP_NONE(0),
        DRAWING_FLIP_90(7),
        DRAWING_FLIP_180(4),
        DRAWING_FLIP_270(2),
        DRAWING_FLIP_MIRROR(3),
        DRAWING_FLIP_MIRROR_90(1),
        DRAWING_FLIP_MIRROR_180(6),
        DRAWING_FLIP_MIRROR_270(5);

        public final int val;

        private DrawingFlip(int val) {
            this.val = val;
        }
    }
}

