/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import ej.annotation.Nullable;
import ej.bon.Constants;
import java.time.zone.ZoneRules;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;

public abstract class ZoneRulesProvider {
    private static final String ZONE_RULES_PROVIDER_CONSTANT = "java.time.zone.DefaultZoneRulesProvider";
    private static final ZoneRulesProvider ZONE_RULES_PROVIDER;

    static {
        try {
            Class clazz = Constants.getClass((String)ZONE_RULES_PROVIDER_CONSTANT);
            ZONE_RULES_PROVIDER = (ZoneRulesProvider)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public static ZoneRules getRules(String zoneId, boolean forCaching) {
        Objects.requireNonNull(zoneId, "zoneId");
        return ZONE_RULES_PROVIDER.provideRules(zoneId, forCaching);
    }

    public static NavigableMap<String, ZoneRules> getVersions(String zoneId) {
        return ZONE_RULES_PROVIDER.provideVersions(zoneId);
    }

    public static Set<String> getAvailableZoneIds() {
        return ZONE_RULES_PROVIDER.provideZoneIds();
    }

    public static boolean refresh() {
        return ZONE_RULES_PROVIDER.provideRefresh();
    }

    protected ZoneRulesProvider() {
    }

    protected abstract Set<String> provideZoneIds();

    @Nullable
    protected abstract ZoneRules provideRules(String var1, boolean var2);

    protected abstract NavigableMap<String, ZoneRules> provideVersions(String var1);

    protected boolean provideRefresh() {
        return false;
    }
}

