/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.HeapLongBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;

class HeapLongBufferR
extends HeapLongBuffer {
    HeapLongBufferR(int cap, int lim) {
        super(cap, lim);
        this.isReadOnly = true;
    }

    HeapLongBufferR(long[] buf, int off, int len) {
        super(buf, off, len);
        this.isReadOnly = true;
    }

    protected HeapLongBufferR(long[] buf, int mark, int pos, int lim, int cap, int off) {
        super(buf, mark, pos, lim, cap, off);
        this.isReadOnly = true;
    }

    @Override
    public LongBuffer slice() {
        long[] hb = this.hb;
        assert (hb != null);
        return new HeapLongBufferR(hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public LongBuffer duplicate() {
        long[] hb = this.hb;
        assert (hb != null);
        return new HeapLongBufferR(hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public LongBuffer put(long x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer put(int i, long x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer put(long[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer put(LongBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

