/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.time.DayOfWeek;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;

public final class TemporalAdjusters {
    private TemporalAdjusters() {
    }

    public static TemporalAdjuster firstDayOfMonth() {
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                return temporal.with(ChronoField.DAY_OF_MONTH, 1L);
            }
        };
    }

    public static TemporalAdjuster lastDayOfMonth() {
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                long lastDay = temporal.range(ChronoField.DAY_OF_MONTH).getMaximum();
                return temporal.with(ChronoField.DAY_OF_MONTH, lastDay);
            }
        };
    }

    public static TemporalAdjuster firstDayOfNextMonth() {
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                return temporal.with(ChronoField.DAY_OF_MONTH, 1L).plus(1L, ChronoUnit.MONTHS);
            }
        };
    }

    public static TemporalAdjuster firstDayOfYear() {
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                return temporal.with(ChronoField.DAY_OF_YEAR, 1L);
            }
        };
    }

    public static TemporalAdjuster lastDayOfYear() {
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                long lastDay = temporal.range(ChronoField.DAY_OF_YEAR).getMaximum();
                return temporal.with(ChronoField.DAY_OF_YEAR, lastDay);
            }
        };
    }

    public static TemporalAdjuster firstDayOfNextYear() {
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                return temporal.with(ChronoField.DAY_OF_YEAR, 1L).plus(1L, ChronoUnit.YEARS);
            }
        };
    }

    public static TemporalAdjuster firstInMonth(DayOfWeek dayOfWeek) {
        return TemporalAdjusters.dayOfWeekInMonth(1, dayOfWeek);
    }

    public static TemporalAdjuster lastInMonth(DayOfWeek dayOfWeek) {
        return TemporalAdjusters.dayOfWeekInMonth(-1, dayOfWeek);
    }

    public static TemporalAdjuster dayOfWeekInMonth(final int ordinal, DayOfWeek dayOfWeek) {
        final int dowValue = dayOfWeek.getValue();
        if (ordinal >= 0) {
            return new TemporalAdjuster(){

                @Override
                public Temporal adjustInto(Temporal temporal) {
                    Temporal temp = temporal.with(ChronoField.DAY_OF_MONTH, 1L);
                    int curDow = temp.get(ChronoField.DAY_OF_WEEK);
                    int dowDiff = (dowValue - curDow + 7) % 7;
                    dowDiff = (int)((long)dowDiff + ((long)ordinal - 1L) * 7L);
                    return temp.plus(dowDiff, ChronoUnit.DAYS);
                }
            };
        }
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                Temporal temp = temporal.with(ChronoField.DAY_OF_MONTH, temporal.range(ChronoField.DAY_OF_MONTH).getMaximum());
                int curDow = temp.get(ChronoField.DAY_OF_WEEK);
                int daysDiff = dowValue - curDow;
                daysDiff = daysDiff == 0 ? 0 : (daysDiff > 0 ? daysDiff - 7 : daysDiff);
                daysDiff = (int)((long)daysDiff - ((long)(-ordinal) - 1L) * 7L);
                return temp.plus(daysDiff, ChronoUnit.DAYS);
            }
        };
    }

    public static TemporalAdjuster next(DayOfWeek dayOfWeek) {
        final int dowValue = dayOfWeek.getValue();
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int calDow = temporal.get(ChronoField.DAY_OF_WEEK);
                int daysDiff = calDow - dowValue;
                return temporal.plus(daysDiff >= 0 ? 7 - daysDiff : -daysDiff, ChronoUnit.DAYS);
            }
        };
    }

    public static TemporalAdjuster nextOrSame(DayOfWeek dayOfWeek) {
        final int dowValue = dayOfWeek.getValue();
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int calDow = temporal.get(ChronoField.DAY_OF_WEEK);
                if (calDow == dowValue) {
                    return temporal;
                }
                int daysDiff = calDow - dowValue;
                return temporal.plus(daysDiff >= 0 ? 7 - daysDiff : -daysDiff, ChronoUnit.DAYS);
            }
        };
    }

    public static TemporalAdjuster previous(DayOfWeek dayOfWeek) {
        final int dowValue = dayOfWeek.getValue();
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int calDow = temporal.get(ChronoField.DAY_OF_WEEK);
                int daysDiff = dowValue - calDow;
                return temporal.minus(daysDiff >= 0 ? 7 - daysDiff : -daysDiff, ChronoUnit.DAYS);
            }
        };
    }

    public static TemporalAdjuster previousOrSame(DayOfWeek dayOfWeek) {
        final int dowValue = dayOfWeek.getValue();
        return new TemporalAdjuster(){

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int calDow = temporal.get(ChronoField.DAY_OF_WEEK);
                if (calDow == dowValue) {
                    return temporal;
                }
                int daysDiff = dowValue - calDow;
                return temporal.minus(daysDiff >= 0 ? 7 - daysDiff : -daysDiff, ChronoUnit.DAYS);
            }
        };
    }
}

