/*
 * Decompiled with CFR 0.152.
 */
package ej.motion;

import ej.motion.Function;

public class Motion {
    private final Function function;
    private final int startValue;
    private final int stopValue;
    private final long duration;

    public Motion(Function function, int startValue, int stopValue, long duration) {
        this.function = function;
        this.startValue = startValue;
        this.stopValue = stopValue;
        this.duration = duration;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getStartValue() {
        return this.startValue;
    }

    public int getStopValue() {
        return this.stopValue;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getValue(long elapsedTime) {
        if (elapsedTime >= this.duration) {
            return this.stopValue;
        }
        if (elapsedTime <= 0L) {
            return this.startValue;
        }
        float t = (float)elapsedTime / (float)this.duration;
        float functionValue = this.function.computeValue(t);
        return Math.round((float)this.startValue + (float)(this.stopValue - this.startValue) * functionValue);
    }
}

