/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.rest.endpoint;

import ej.hoka.http.HTTPResponse;
import ej.hoka.http.support.MIMEUtils;
import ej.hoka.rest.endpoint.ResourceRestEndpoint;
import java.io.InputStream;

public class GzipResourceEndpoint
extends ResourceRestEndpoint {
    public static final String GZIP_FILE_EXTENSION = ".gz";
    private static final String CONTENT_ENCODING_GZIP = "gzip";

    public GzipResourceEndpoint(String uri, String resource) {
        super(uri, resource);
    }

    public GzipResourceEndpoint(String uri, String resource, String mimetype) {
        super(uri, resource, mimetype);
    }

    @Override
    protected HTTPResponse getResourceResponse() {
        InputStream resourceAsStream = this.getResourceAsStream();
        if (resourceAsStream == null) {
            return null;
        }
        String mimeType = MIMEUtils.getMIMEType(this.resource.substring(0, this.resource.length() - GZIP_FILE_EXTENSION.length()));
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        HTTPResponse response = new HTTPResponse("200 OK", mimeType, resourceAsStream);
        response.addHeaderField("content-encoding", CONTENT_ENCODING_GZIP);
        return response;
    }
}

