/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.requesthandler;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.http.requesthandler.RequestHandler;
import ej.hoka.http.support.MIMEUtils;
import ej.hoka.log.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ResourceRequestHandler
implements RequestHandler {
    private static final String SLASH = "/";
    private static final String DEFAULT_INDEX = "index.html";
    private static final String DIRECTORY_TRAVERSAL_SEQUENCE = "..";
    private final String root;
    private final String index;

    public ResourceRequestHandler(String rootDirectory) {
        this(rootDirectory, DEFAULT_INDEX);
    }

    public ResourceRequestHandler(String rootDirectory, String index) {
        if (rootDirectory.endsWith(SLASH)) {
            rootDirectory = rootDirectory.substring(0, rootDirectory.length() - 1);
        }
        this.root = rootDirectory;
        this.index = index;
    }

    @Override
    public HTTPResponse process(HTTPRequest request, Map<String, String> attributes) {
        HTTPResponse response;
        InputStream resourceStream;
        String uri = String.valueOf(this.root) + request.getURI();
        if (uri.contains(DIRECTORY_TRAVERSAL_SEQUENCE)) {
            Messages.LOGGER.log('I', "Hoka", -4);
            return null;
        }
        if (uri.endsWith(SLASH)) {
            uri = String.valueOf(uri) + this.index;
        }
        if ((resourceStream = this.getClass().getResourceAsStream(uri)) == null) {
            return null;
        }
        try {
            response = new HTTPResponse(resourceStream, resourceStream.available());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        response.setMimeType(MIMEUtils.getMIMEType(uri));
        response.setStatus("200 OK");
        return response;
    }
}

