/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.auth;

import ej.hoka.auth.Authenticator;
import ej.hoka.auth.InMemorySessionDataAccess;
import ej.hoka.auth.Session;
import ej.hoka.auth.SessionDataAccess;
import java.util.Base64;
import java.util.Random;

public class SessionAuthenticator
implements Authenticator {
    private static final long ONE_SECOND = 1000L;
    private static final long DEFAULT_SESSION_LIFETIME = 3600L;
    private static final int TOKEN_SIZE = 128;
    private final Random randomNumberGenerator;
    private final long sessionLifetime;
    private final SessionDataAccess database;

    @Deprecated
    public SessionAuthenticator() {
        this(3600L);
    }

    public SessionAuthenticator(Random random) {
        this(random, 3600L);
    }

    @Deprecated
    public SessionAuthenticator(long sessionLifetime) {
        this(sessionLifetime, new InMemorySessionDataAccess());
    }

    public SessionAuthenticator(Random random, long sessionLifetime) {
        this(random, sessionLifetime, new InMemorySessionDataAccess());
    }

    @Deprecated
    public SessionAuthenticator(long sessionLifetime, SessionDataAccess database) {
        this(new Random(), sessionLifetime, database);
    }

    public SessionAuthenticator(Random random, long sessionLifetime, SessionDataAccess database) {
        this.randomNumberGenerator = random;
        this.database = database;
        this.sessionLifetime = sessionLifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String login(String uid) {
        SessionDataAccess sessionDataAccess = this.database;
        synchronized (sessionDataAccess) {
            Session session = this.database.getSessionByUser(uid);
            if (session != null) {
                if (session.isExpired()) {
                    this.database.removeSession(session);
                } else {
                    return session.sessionID;
                }
            }
            String sessionId = this.generateSessionID();
            long expiration = this.generateExpiration();
            this.database.addSession(new Session(uid, sessionId, expiration));
            return sessionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticate(String sessionID) {
        SessionDataAccess sessionDataAccess = this.database;
        synchronized (sessionDataAccess) {
            Session session;
            block6: {
                block5: {
                    session = this.database.getSessionByID(sessionID);
                    if (session != null) break block5;
                    return null;
                }
                if (!session.isExpired()) break block6;
                this.database.removeSession(session);
                return null;
            }
            return session.userID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String sessionID) {
        SessionDataAccess sessionDataAccess = this.database;
        synchronized (sessionDataAccess) {
            if (this.database.getSessionByID(sessionID) != null) {
                this.database.refreshSession(sessionID, this.generateExpiration());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout(String sessionID) {
        SessionDataAccess sessionDataAccess = this.database;
        synchronized (sessionDataAccess) {
            block4: {
                Session session = this.database.getSessionByID(sessionID);
                if (session == null) break block4;
                this.database.removeSession(session);
                return true;
            }
            return false;
        }
    }

    protected String generateSessionID() {
        byte[] sidBytes = new byte[128];
        this.randomNumberGenerator.nextBytes(sidBytes);
        return Base64.getEncoder().encodeToString(sidBytes);
    }

    protected long generateExpiration() {
        return System.currentTimeMillis() / 1000L + this.sessionLifetime;
    }
}

