/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.background;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Painter;
import ej.mwt.style.background.Background;

public class RoundedBackground
implements Background {
    private static final int FADE = 1;
    private final int color;
    private final char cornerRadius;
    private final char borderThickness;

    @Deprecated
    public RoundedBackground(int color, int cornerRadius) {
        this(color, cornerRadius, 0);
    }

    public RoundedBackground(int color, int cornerRadius, int borderThickness) {
        this.color = color;
        this.cornerRadius = (char)XMath.limit((int)cornerRadius, (int)0, (int)65535);
        this.borderThickness = (char)XMath.limit((int)borderThickness, (int)0, (int)65535);
    }

    public int getColor() {
        return this.color;
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    @Override
    public boolean isTransparent(int width, int height) {
        return true;
    }

    @Override
    public void apply(GraphicsContext g, int width, int height) {
        g.setColor(this.color);
        char thickness = this.borderThickness;
        int radius = Math.min(Math.max(this.cornerRadius, thickness + '\u0001'), Math.min(width, height) >> 1);
        int diameter = radius << 1;
        int includedDiameter = diameter - (thickness + '\u0001' << 2);
        char originShift = thickness;
        int sizeShift = thickness << 1;
        Painter.fillRoundedRectangle((GraphicsContext)g, (int)originShift, (int)originShift, (int)(width - sizeShift), (int)(height - sizeShift), (int)includedDiameter, (int)includedDiameter);
        g.setBackgroundColor(this.color);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RoundedBackground) {
            RoundedBackground background = (RoundedBackground)obj;
            return this.color == background.color && this.cornerRadius == background.cornerRadius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.color + this.cornerRadius;
    }
}

