/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.security;

import com.microej.kf.util.security.FeaturePolicyPermission;
import com.microej.kf.util.security.SecurityPolicyResourceLoader;
import ej.annotation.Nullable;
import ej.basictool.map.PackedMap;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class KernelSecurityPolicyManager
extends SecurityManager
implements FeatureStateListener {
    private static final Logger LOGGER = Logger.getLogger(KernelSecurityPolicyManager.class.getName());
    private final PackedMap<Feature, List<FeaturePolicyPermission>> featurePermissionsMap = new PackedMap();
    private final SecurityPolicyResourceLoader securityPolicyResourceLoader;

    public KernelSecurityPolicyManager(SecurityPolicyResourceLoader securityPolicyResourceLoader) {
        this.securityPolicyResourceLoader = securityPolicyResourceLoader;
        this.handleFeatureStateUpdates();
    }

    private void handleFeatureStateUpdates() {
        Kernel.addFeatureStateListener((FeatureStateListener)this);
    }

    @Override
    public void checkPermission(Permission perm) {
        if (!Kernel.isInKernelMode()) {
            Feature f = (Feature)Kernel.getContextOwner();
            Kernel.enter();
            List featurePermissionList = (List)this.featurePermissionsMap.get((Object)f);
            if (featurePermissionList != null) {
                this.checkPermission(perm, f);
            } else {
                throw new SecurityException();
            }
        }
    }

    private void checkPermission(Permission perm, Feature feature) {
        LOGGER.fine("Checking permission for: " + perm.getClass().getName() + " name: " + perm.getName() + " actions: " + perm.getActions());
        List permissionList = (List)this.featurePermissionsMap.get((Object)feature);
        boolean isAllowed = false;
        for (FeaturePolicyPermission policyPermission : permissionList) {
            if (!policyPermission.getPermissionClassName().equals("*") && !policyPermission.getPermissionClassName().equals(perm.getClass().getName())) continue;
            PackedMap<String, List<String>> nameActionsMap = policyPermission.getNameActionsMap();
            if (nameActionsMap.isEmpty()) {
                isAllowed = true;
                break;
            }
            String bestNameMatch = this.findBestNameMatch(nameActionsMap, perm);
            if (bestNameMatch.isEmpty()) break;
            List actionList = (List)policyPermission.getNameActionsMap().get((Object)bestNameMatch);
            if (actionList != null) {
                isAllowed = this.isActionPresent(actionList, perm);
            }
            if (isAllowed) break;
        }
        if (!isAllowed) {
            throw new SecurityException(String.valueOf(feature.getName()) + " is not allowed to access " + perm.getClass().getName() + " (name: " + perm.getName() + " - actions: " + perm.getActions() + ")");
        }
        LOGGER.fine("Permission granted for: " + feature.getName() + " for permission: " + perm.getClass().getName() + " name: " + perm.getName() + " actions: " + perm.getActions());
    }

    private List<String> splitStringArray(String input, char splitter) {
        ArrayList<String> result = new ArrayList<String>();
        int startIndex = 0;
        int i = 0;
        while (i < input.length()) {
            if (input.charAt(i) == splitter) {
                result.add(input.substring(startIndex, i));
                startIndex = i + 1;
            }
            ++i;
        }
        result.add(input.substring(startIndex));
        return result;
    }

    public void addToPermissionMap(Feature feature) {
        String resourceFileName = System.getProperty("feature.policy.name", "/feature.policy.json");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = feature.getResourceAsStream(resourceFileName.startsWith("/") ? resourceFileName : "/" + resourceFileName);){
                ArrayList permissionList = this.securityPolicyResourceLoader.loadFeaturePermissions(inputStream);
                this.featurePermissionsMap.put((Object)feature, (Object)(permissionList == null ? new ArrayList() : permissionList));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    private String findBestNameMatch(PackedMap<String, List<String>> nameActionsMap, Permission perm) {
        String bestNameMatch = "";
        for (String name : nameActionsMap.keySet()) {
            if (perm.getName() == null && name.equals("null") || perm.getName() != null && name.equals(perm.getName())) {
                bestNameMatch = name;
                break;
            }
            if (!name.endsWith("*") || perm.getName() != null && !perm.getName().contains(name.substring(0, name.length() - 1)) || name.length() <= bestNameMatch.length()) continue;
            bestNameMatch = name;
        }
        return bestNameMatch;
    }

    private boolean isActionPresent(List<String> actionList, Permission perm) {
        boolean isActionPresent = false;
        if (actionList.isEmpty() || actionList.contains("*") || perm.getActions() == null && actionList.contains("null") || perm.getActions() != null && actionList.containsAll(this.splitStringArray(perm.getActions(), ','))) {
            isActionPresent = true;
        }
        return isActionPresent;
    }

    public void stateChanged(Feature feature, @Nullable Feature.State previousState) {
        if (feature.getState().equals((Object)Feature.State.INSTALLED) && previousState == null) {
            this.addToPermissionMap(feature);
        } else if (feature.getState().equals((Object)Feature.State.UNINSTALLED) && previousState != null && previousState.equals((Object)Feature.State.STOPPED)) {
            this.featurePermissionsMap.remove((Object)feature);
        }
    }
}

