/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style;

import ej.annotation.Nullable;
import ej.microui.display.Font;
import ej.mwt.style.DefaultStyle;
import ej.mwt.style.Style;
import ej.mwt.style.background.Background;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.style.outline.Outline;
import ej.mwt.util.Alignment;

public class EditableStyle
implements Style {
    public static final int MAX_EXTRA_FIELDS = 7;
    private static final Object[] EMPTY_EXTRA_FIELDS = new Object[0];
    private Dimension dimension;
    private byte horizontalAlignment;
    private byte verticalAlignment;
    private Outline margin;
    private Outline border;
    private Outline padding;
    private Background background;
    private int color;
    private Font font;
    private Object[] extraFields;

    public EditableStyle() {
        this.dimension = DefaultStyle.DIMENSION;
        this.horizontalAlignment = 0;
        this.verticalAlignment = (byte)3;
        this.margin = DefaultStyle.MARGIN;
        this.border = DefaultStyle.BORDER;
        this.padding = DefaultStyle.PADDING;
        this.background = DefaultStyle.BACKGROUND;
        this.color = 0;
        this.font = Font.getDefaultFont();
        this.extraFields = EMPTY_EXTRA_FIELDS;
    }

    public EditableStyle(EditableStyle style) {
        this.dimension = style.dimension;
        this.horizontalAlignment = style.horizontalAlignment;
        this.verticalAlignment = style.verticalAlignment;
        this.margin = style.margin;
        this.border = style.border;
        this.padding = style.padding;
        this.background = style.background;
        this.color = style.color;
        this.font = style.font;
        this.extraFields = style.extraFields == EMPTY_EXTRA_FIELDS ? EMPTY_EXTRA_FIELDS : (Object[])style.extraFields.clone();
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public Outline getMargin() {
        return this.margin;
    }

    @Override
    public Outline getBorder() {
        return this.border;
    }

    @Override
    public Outline getPadding() {
        return this.padding;
    }

    @Override
    public Background getBackground() {
        return this.background;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public <T> T getExtraObject(int fieldId, Class<T> clazz, T defaultValue) {
        Object value;
        EditableStyle.validateExtraFieldId(fieldId);
        Object[] extraFields = this.extraFields;
        if (fieldId < extraFields.length && (value = extraFields[fieldId]) != null) {
            T castedValue = clazz.cast(value);
            assert (castedValue != null);
            return castedValue;
        }
        return defaultValue;
    }

    @Override
    public int getExtraInt(int fieldId, int defaultValue) {
        Object value;
        EditableStyle.validateExtraFieldId(fieldId);
        Object[] extraFields = this.extraFields;
        if (fieldId < extraFields.length && (value = extraFields[fieldId]) != null) {
            return (Integer)value;
        }
        return defaultValue;
    }

    @Override
    public float getExtraFloat(int fieldId, float defaultValue) {
        Object value;
        EditableStyle.validateExtraFieldId(fieldId);
        Object[] extraFields = this.extraFields;
        if (fieldId < extraFields.length && (value = extraFields[fieldId]) != null) {
            return ((Float)value).floatValue();
        }
        return defaultValue;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        Alignment.validateHorizontalAlignment(horizontalAlignment);
        this.horizontalAlignment = (byte)horizontalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        Alignment.validateVerticalAlignment(verticalAlignment);
        this.verticalAlignment = (byte)verticalAlignment;
    }

    public void setMargin(Outline margin) {
        this.margin = margin;
    }

    public void setBorder(Outline border) {
        this.border = border;
    }

    public void setPadding(Outline padding) {
        this.padding = padding;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setExtraObject(int fieldId, Object fieldValue) {
        EditableStyle.validateExtraFieldId(fieldId);
        this.extraFields = EditableStyle.setExtraField(this.extraFields, fieldId, fieldValue);
    }

    public void setExtraInt(int fieldId, int fieldValue) {
        this.setExtraObject(fieldId, fieldValue);
    }

    public void setExtraFloat(int fieldId, float fieldValue) {
        this.setExtraObject(fieldId, Float.valueOf(fieldValue));
    }

    protected static void validateExtraFieldId(int fieldId) {
        if (fieldId < 0 || fieldId >= 7) {
            throw new IllegalArgumentException();
        }
    }

    private static Object[] setExtraField(Object[] extraFields, int fieldId, Object fieldValue) {
        if (fieldId >= extraFields.length) {
            Object[] newExtraFields = new Object[fieldId + 1];
            System.arraycopy(extraFields, 0, newExtraFields, 0, extraFields.length);
            extraFields = newExtraFields;
        }
        extraFields[fieldId] = fieldValue;
        return extraFields;
    }

    private static boolean identityEquals(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EditableStyle)) {
            return false;
        }
        EditableStyle other = (EditableStyle)obj;
        return this.dimension.equals(other.dimension) && this.horizontalAlignment == other.horizontalAlignment && this.verticalAlignment == other.verticalAlignment && this.margin.equals(other.margin) && this.border.equals(other.border) && this.padding.equals(other.padding) && this.background.equals(other.background) && this.color == other.color && this.font == other.font && EditableStyle.identityEquals(this.extraFields, other.extraFields);
    }

    @Override
    public int hashCode() {
        return this.dimension.hashCode() - this.horizontalAlignment + this.verticalAlignment - this.margin.hashCode() + this.border.hashCode() - this.padding.hashCode() + this.background.hashCode() - this.color + this.extraFields.length;
    }
}

