/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import ej.annotation.NonNull;
import ej.annotation.Nullable;
import ej.microui.MicroUI;
import ej.microui.display.Font;
import ej.microui.display.GraphicsContext;
import ej.microui.event.Event;
import ej.microui.util.EventHandler;
import ej.mwt.Desktop;
import ej.mwt.Renderable;

class RenderableHelper {
    private static Font DefaultFont;

    private RenderableHelper() {
    }

    static void paintRenderable(@NonNull GraphicsContext g, @Nullable Desktop desktop, @NonNull Renderable renderable) {
        if (desktop == null) {
            return;
        }
        if (!desktop.checkPaintFrom(renderable)) {
            return;
        }
        if (g.getClipWidth() == 0 || g.getClipHeight() == 0) {
            return;
        }
        RenderableHelper.reset(g);
        renderable.render(g);
    }

    private static void reset(@NonNull GraphicsContext g) {
        g.setColor(0);
        g.removeBackgroundColor();
        Font defaultFont = RenderableHelper.getDefaultFont();
        if (defaultFont != null) {
            defaultFont.resetRatios();
        }
        g.setFont(defaultFont);
        g.setStrokeStyle(0);
        g.setEllipsis(false);
    }

    @NonNull
    private static Font getDefaultFont() {
        if (DefaultFont == null) {
            DefaultFont = Font.getDefaultFont();
        }
        return DefaultFont;
    }

    static int getDirection(int event) {
        if (Event.getType((int)event) == 0) {
            int data = Event.getData((int)event);
            switch (data) {
                case 2: {
                    return 1;
                }
                case 4: {
                    return 4;
                }
                case 3: {
                    return 2;
                }
                case 5: {
                    return 8;
                }
            }
        }
        return 0;
    }

    static boolean handleEvent(int event, @Nullable EventHandler eventHandler) {
        if (eventHandler != null) {
            try {
                return eventHandler.handleEvent(event);
            }
            catch (Throwable e) {
                MicroUI.MicroUI.errorLog(e);
            }
        }
        return false;
    }
}

