/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import com.is2t.tools.ArrayTools;
import ej.annotation.NonNull;
import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.mwt.Panel;
import ej.mwt.RenderableHelper;
import ej.mwt.Widget;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Composite
extends Widget {
    @NonNull
    private static final Widget[] EMPTY_WIDGETS = new Widget[0];
    @NonNull
    private Widget[] widgets = EMPTY_WIDGETS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(@NonNull Widget widget) throws NullPointerException, IllegalArgumentException {
        Composite composite = this;
        synchronized (composite) {
            if (widget.panel != null || widget.parent != null) {
                throw new IllegalArgumentException();
            }
            widget.setParent(this);
            this.widgets = (Widget[])ArrayTools.add((Object[])this.widgets, (Object)widget);
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(@NonNull Widget widget) throws NullPointerException {
        Composite composite = this;
        synchronized (composite) {
            int oldLength = this.widgets.length;
            this.widgets = (Widget[])ArrayTools.remove((Object[])this.widgets, (Object)widget);
            if (oldLength != this.widgets.length) {
                boolean ownsFocus = widget.isFocusOwner();
                widget.setParent(null);
                Panel panel = this.panel;
                if (panel != null && ownsFocus) {
                    panel.setFocus(null);
                }
            }
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllWidgets() {
        Panel panel = this.panel;
        boolean focusOwner = this.isFocusOwner();
        Composite composite = this;
        synchronized (composite) {
            Widget[] widgets = this.widgets;
            int i = widgets.length;
            while (--i >= 0) {
                Widget widget = widgets[i];
                widget.setParent(null);
            }
            this.widgets = new Widget[0];
        }
        if (panel != null && panel.getFocus() != this && focusOwner) {
            panel.setFocus(null);
        }
        this.invalidate();
    }

    @Override
    public void showNotify() {
        super.showNotify();
        Widget[] widgetArray = this.widgets;
        int n = this.widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            widget.showNotify();
            ++n2;
        }
    }

    @Override
    public void hideNotify() {
        super.hideNotify();
        Widget[] widgetArray = this.widgets;
        int n = this.widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            widget.hideNotify();
            ++n2;
        }
    }

    @Override
    @Nullable
    public Widget getWidgetAt(int x, int y) {
        if (!this.contains(x, y)) {
            return null;
        }
        int relX = x - this.x;
        int relY = y - this.y;
        Widget[] widgets = this.widgets;
        int i = widgets.length;
        while (--i >= 0) {
            Widget at = widgets[i].getWidgetAt(relX, relY);
            if (at == null) continue;
            return at;
        }
        return this;
    }

    @NonNull
    public Iterator<Widget> iterator() {
        return new Iterator<Widget>(){
            int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor != Composite.this.widgets.length;
            }

            @Override
            public Widget next() {
                int i = this.cursor;
                Widget[] widgets = Composite.this.widgets;
                if (i < widgets.length) {
                    Widget next = widgets[i];
                    this.cursor = i + 1;
                    return next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NonNull
    public Widget getWidget(int index) throws IndexOutOfBoundsException {
        return this.widgets[index];
    }

    @NonNull
    public Widget[] getWidgets() {
        return (Widget[])ArrayTools.copy((Object[])this.widgets, Widget[].class);
    }

    public int getWidgetsCount() {
        return this.widgets.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean isFocusOwner() {
        try {
            Widget focus = this.panel.getFocus();
            while (true) {
                if (focus == null) {
                    return super.isFocusOwner();
                }
                if (focus == this) {
                    return true;
                }
                focus = focus.getParent();
            }
        }
        catch (NullPointerException nullPointerException) {}
        return super.isFocusOwner();
    }

    @Override
    public void requestFocus() {
        if (this.getWidgetsCount() != 0) {
            this.requestFocusFrom(0, 8);
        }
    }

    @Override
    public boolean requestFocus(int direction) throws IllegalArgumentException {
        int widgetsCount = this.getWidgetsCount();
        if (widgetsCount != 0 && this.isEnabled()) {
            switch (direction) {
                case 1: 
                case 4: {
                    return this.requestFocusFrom(widgetsCount - 1, direction);
                }
                case 2: 
                case 8: {
                    return this.requestFocusFrom(0, direction);
                }
            }
            throw new IllegalArgumentException();
        }
        return false;
    }

    public boolean requestFocusFrom(int from, int direction) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.checkFrom(from);
        do {
            if (!this.getWidget(from).requestFocus(direction)) continue;
            return true;
        } while ((from = this.getNext(from, direction)) != -1);
        return false;
    }

    public int getNext(int from, int direction) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.checkFrom(from);
        switch (direction) {
            case 1: 
            case 4: {
                return this.getPrevious(from);
            }
            case 2: 
            case 8: {
                return this.getNext(from);
            }
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public Widget getFocus() {
        try {
            return this.widgets[this.getFocusIndex()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public int getFocusIndex() {
        int widgetsLength;
        Widget[] widgets = this.widgets;
        int i = widgetsLength = widgets.length;
        while (--i >= 0) {
            if (!widgets[i].hasFocus()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public abstract void validate(int var1, int var2);

    @Override
    public boolean handleEvent(int event) {
        return super.handleEvent(event) || this.handleDirection(event);
    }

    private boolean handleDirection(int event) {
        int direction = RenderableHelper.getDirection(event);
        if (direction != 0) {
            int i = this.getFocusIndex();
            try {
                i = this.getNext(i, direction);
                return this.requestFocusFrom(i, direction);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        return false;
    }

    @Override
    void setPanelOnly(@Nullable Panel panel) {
        super.setPanelOnly(panel);
        Widget[] contents = this.widgets;
        int i = contents.length;
        while (--i >= 0) {
            contents[i].setPanelOnly(panel);
        }
    }

    private void checkFrom(int from) {
        if (from < 0 || from >= this.getWidgetsCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private int getNext(int from) {
        if (++from >= this.getWidgetsCount()) {
            return -1;
        }
        return from;
    }

    private int getPrevious(int from) {
        return --from;
    }

    @Override
    void paint(@NonNull GraphicsContext g, int translateX, int translateY, int x, int y, int width, int height) {
        if (!this.visible) {
            return;
        }
        this.beforePaint(g, translateX, translateY, x, y, width, height);
        width = g.getClipWidth();
        height = g.getClipHeight();
        if (width == 0 || height == 0) {
            return;
        }
        translateX = g.getTranslateX();
        translateY = g.getTranslateY();
        x = g.getClipX();
        y = g.getClipY();
        this.paint(g);
        Widget[] widgets = this.widgets;
        int length = widgets.length;
        int i = -1;
        while (++i < length) {
            widgets[i].paint(g, translateX, translateY, x, y, width, height);
        }
    }
}

