/*
 * Decompiled with CFR 0.152.
 */
package ej.aws.iot;

import ej.bon.Util;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class AwsIotClientOptions {
    private static final String ID_PREFIX = "MicroEJ";
    private static final int DEFAULT_AWS_PORT = 8883;
    private static final int DEFAULT_CONNECTION_TIME_OUT = 30;
    private static final int DEFAULT_CONNECTION_KEEP_ALIVE = 60;
    private final String host;
    private final int port;
    private final String thingName;
    private final String clientId;
    private final int timeout;
    private final int keepAlive;
    private final SocketFactory socketFactory;
    private final String username;
    private final char[] password;

    private AwsIotClientOptions(String serverHost, int serverPort, String thingId, String clientId, int timeout, int keepAlive, SocketFactory sslContext, String username, char[] password) {
        this.host = serverHost;
        this.port = serverPort;
        this.thingName = thingId;
        this.clientId = clientId;
        this.timeout = timeout;
        this.keepAlive = keepAlive;
        this.socketFactory = sslContext;
        this.username = username;
        this.password = password;
    }

    public String getServerHost() {
        return this.host;
    }

    public int getServerPort() {
        return this.port;
    }

    public String getThingName() {
        return this.thingName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public String getServerURL() {
        return String.valueOf(this.socketFactory instanceof SSLSocketFactory ? "ssl://" : "tcp://") + this.host + ":" + this.port;
    }

    public static String generateClientId() {
        return ID_PREFIX + Util.platformTimeNanos();
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password == null ? null : (char[])this.password.clone();
    }

    /* synthetic */ AwsIotClientOptions(String string, int n, String string2, String string3, int n2, int n3, SocketFactory socketFactory, String string4, char[] cArray, AwsIotClientOptions awsIotClientOptions) {
        this(string, n, string2, string3, n2, n3, socketFactory, string4, cArray);
    }

    public static class Builder {
        private String host;
        private int port = 8883;
        private String thingName;
        private String clientId;
        private int timeout = 30;
        private int keepAlive = 60;
        private SocketFactory socketFactory = null;
        private String username;
        private char[] password;

        public static Builder builder() {
            return new Builder();
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public Builder clientID(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder keepAlive(int keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder secure(SocketFactory context) {
            this.socketFactory = context;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(char[] password) {
            this.password = password;
            return this;
        }

        public AwsIotClientOptions build() {
            if (this.host == null || this.port == 0 || this.thingName == null || this.thingName.isEmpty() || this.clientId == null || this.clientId.isEmpty() || this.timeout <= 0 || this.keepAlive <= 0) {
                throw new IllegalArgumentException();
            }
            return new AwsIotClientOptions(this.host, this.port, this.thingName, this.clientId, this.timeout, this.keepAlive, this.socketFactory, this.username, this.password, null);
        }
    }
}

