/*
 * Decompiled with CFR 0.152.
 */
package ej.aws.iot;

import ej.aws.iot.AwsIotClientCallback;
import ej.aws.iot.AwsIotClientOptions;
import ej.aws.iot.AwsIotConnectionListener;
import ej.aws.iot.AwsIotException;
import ej.aws.iot.AwsIotMessage;
import ej.aws.iot.AwsIotMessageCallback;
import ej.aws.iot.ShadowAction;
import ej.aws.iot.ShadowResult;
import ej.util.concurrent.SingleThreadExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;

public class AwsIotClient {
    private static final String SLASH = "/";
    private static final String NAME = "/name/";
    private static final byte[] EMPTY_MESSAGE = "{}".getBytes();
    private static final String SHADOW = "/shadow";
    private static final String SHADOW_BASE = "$aws/things/";
    private final AwsIotClientOptions options;
    private MqttClient mqttClient;
    private ExecutorService executorService;
    private final AwsIotConnectionListener connectionListener;
    private Map<String, AwsIotMessageCallback> subscribers;

    public AwsIotClient(AwsIotClientOptions options) {
        this(options, null);
    }

    public AwsIotClient(AwsIotClientOptions options, AwsIotConnectionListener connectionCallback) {
        this.options = options;
        this.connectionListener = connectionCallback;
    }

    public void connect() throws AwsIotException {
        MqttClient mqttClient;
        Map<String, AwsIotMessageCallback> subscribers;
        ExecutorService executor = this.executorService;
        if (executor == null) {
            this.executorService = executor = new SingleThreadExecutor();
        }
        if ((subscribers = this.subscribers) == null) {
            this.subscribers = subscribers = new HashMap<String, AwsIotMessageCallback>(0);
        }
        if ((mqttClient = this.mqttClient) == null) {
            mqttClient = new MqttClient(this.options.getServerURL(), this.options.getClientId());
            mqttClient.setCallback((MqttCallback)new AwsIotClientCallback(this));
        }
        AwsIotClientOptions options = this.options;
        assert (options != null);
        MqttConnectOptions mqttOptions = new MqttConnectOptions();
        mqttOptions.setConnectionTimeout(options.getTimeout());
        mqttOptions.setKeepAliveInterval(options.getKeepAlive());
        mqttOptions.setSocketFactory(options.getSocketFactory());
        String usernameOrEmpty = options.getUsername() == null ? "" : options.getUsername();
        mqttOptions.setUserName(String.valueOf(usernameOrEmpty) + "?SDK=MicroEJ&Version=" + "2.0.0");
        mqttOptions.setPassword(options.getPassword());
        try {
            mqttClient.connect(mqttOptions);
            this.mqttClient = mqttClient;
        }
        catch (MqttException e) {
            throw new AwsIotException(e);
        }
    }

    public boolean isConnected() {
        MqttClient mqttClient = this.mqttClient;
        return mqttClient.isConnected();
    }

    public void disconnect() throws AwsIotException {
        try {
            MqttClient mqttClient = this.mqttClient;
            assert (mqttClient != null);
            mqttClient.disconnect();
        }
        catch (MqttException e) {
            throw new AwsIotException(e);
        }
    }

    public void close() throws AwsIotException {
        try {
            MqttClient mqttClient = this.mqttClient;
            assert (mqttClient != null);
            mqttClient.close();
            ExecutorService executorService = this.executorService;
            assert (executorService != null);
            executorService.shutdown();
            this.executorService = null;
            Map<String, AwsIotMessageCallback> subscribers = this.subscribers;
            assert (subscribers != null);
            subscribers.clear();
            this.subscribers = null;
        }
        catch (MqttException e) {
            throw new AwsIotException(e);
        }
    }

    public void subscribe(String topic, AwsIotMessageCallback subscriber) throws AwsIotException {
        this.subscribe(topic, subscriber, 0);
    }

    public void subscribe(String topic, AwsIotMessageCallback subscriber, int qos) throws AwsIotException {
        try {
            MqttClient mqttClient = this.mqttClient;
            assert (mqttClient != null);
            mqttClient.subscribe(topic, qos);
            Map<String, AwsIotMessageCallback> subscribers = this.subscribers;
            assert (subscriber != null);
            subscribers.put(topic, subscriber);
        }
        catch (MqttException t) {
            throw new AwsIotException(t);
        }
    }

    public void unsubscribe(String topic) throws AwsIotException {
        try {
            MqttClient mqttClient = this.mqttClient;
            assert (mqttClient != null);
            mqttClient.unsubscribe(topic);
            Map<String, AwsIotMessageCallback> subscribers = this.subscribers;
            assert (subscribers != null);
            subscribers.remove(topic);
        }
        catch (MqttException t) {
            throw new AwsIotException(t);
        }
    }

    public void publish(AwsIotMessage message) throws AwsIotException {
        this.publish(message.getTopic(), message.getPayload(), message.getQos(), message.isRetained());
    }

    public void publish(String topic, byte[] data) throws AwsIotException {
        this.publish(topic, data, 0);
    }

    public void publish(String topic, byte[] data, int qos) throws AwsIotException {
        this.publish(topic, data, qos, false);
    }

    public void publish(String topic, byte[] data, int qos, boolean retained) throws AwsIotException {
        try {
            MqttClient mqttClient = this.mqttClient;
            assert (mqttClient != null);
            mqttClient.publish(topic, data, qos, retained);
        }
        catch (MqttException t) {
            throw new AwsIotException(t);
        }
    }

    public void getShadow() throws AwsIotException {
        this.getShadow(null);
    }

    public void getShadow(int qos) throws AwsIotException {
        this.getShadow(null, qos);
    }

    public void getShadow(String shadowName) throws AwsIotException {
        this.getShadow(shadowName, 0);
    }

    public void getShadow(String shadowName, int qos) throws AwsIotException {
        String topic = this.buildShadowTopicName(shadowName, ShadowAction.get, null);
        this.publish(topic, EMPTY_MESSAGE, qos);
    }

    public void updateShadow(byte[] message) throws AwsIotException {
        this.updateShadow(null, message);
    }

    public void updateShadow(byte[] message, int qos) throws AwsIotException {
        this.updateShadow(null, message, qos);
    }

    public void updateShadow(String shadowName, byte[] message) throws AwsIotException {
        this.updateShadow(shadowName, message, 0);
    }

    public void updateShadow(String shadowName, byte[] message, int qos) throws AwsIotException {
        String topic = this.buildShadowTopicName(shadowName, ShadowAction.update, null);
        this.publish(topic, message, qos);
    }

    public void deleteShadow() throws AwsIotException {
        this.deleteShadow(null);
    }

    public void deleteShadow(int qos) throws AwsIotException {
        this.deleteShadow(null, qos);
    }

    public void deleteShadow(String shadowName) throws AwsIotException {
        this.deleteShadow(shadowName, 0);
    }

    public void deleteShadow(String shadowName, int qos) throws AwsIotException {
        String topic = this.buildShadowTopicName(shadowName, ShadowAction.delete, null);
        this.publish(topic, EMPTY_MESSAGE, qos);
    }

    public void subscribeToShadow(ShadowAction action, ShadowResult result, AwsIotMessageCallback callback) throws AwsIotException {
        this.subscribeToShadow(null, action, result, callback);
    }

    public void subscribeToShadow(String shadowName, ShadowAction action, ShadowResult result, AwsIotMessageCallback callback) throws AwsIotException {
        String topic = this.buildShadowTopicName(shadowName, action, result);
        this.subscribe(topic, callback);
    }

    public void subscribeToShadow(ShadowAction action, ShadowResult result, AwsIotMessageCallback callback, int qos) throws AwsIotException {
        this.subscribeToShadow(null, action, result, callback, qos);
    }

    public void subscribeToShadow(String shadowName, ShadowAction action, ShadowResult result, AwsIotMessageCallback callback, int qos) throws AwsIotException {
        String topic = this.buildShadowTopicName(shadowName, action, result);
        this.subscribe(topic, callback, qos);
    }

    public void unsubscribeFromShadow(ShadowAction action, ShadowResult result) throws AwsIotException {
        String topic = this.buildShadowTopicName(null, action, result);
        this.unsubscribe(topic);
    }

    public void unsubscribeFromShadow(String shadowName, ShadowAction action, ShadowResult result) throws AwsIotException {
        String topic = this.buildShadowTopicName(shadowName, action, result);
        this.unsubscribe(topic);
    }

    public AwsIotClientOptions getClientOptions() {
        return this.options;
    }

    protected void dispatch(AwsIotMessage message) {
        Map<String, AwsIotMessageCallback> subscribers = this.subscribers;
        assert (subscribers != null);
        if (subscribers.containsKey(message.getTopic())) {
            AwsIotMessageCallback callback = subscribers.get(message.getTopic());
            assert (callback != null);
            ExecutorService executorService = this.executorService;
            assert (executorService != null);
            executorService.execute(new MessageDispatcher(callback, message));
        }
    }

    protected void connectionLost(Throwable cause) {
        AwsIotConnectionListener connectionListener = this.connectionListener;
        if (connectionListener != null) {
            connectionListener.connectionLost(cause);
        }
    }

    private String buildShadowTopicName(String shadowName, ShadowAction action, ShadowResult result) {
        if ((ShadowAction.get.equals((Object)action) || ShadowAction.delete.equals((Object)action)) && (ShadowResult.delta.equals((Object)result) || ShadowResult.documents.equals((Object)result))) {
            throw new IllegalArgumentException();
        }
        AwsIotClientOptions options = this.options;
        StringBuilder topic = new StringBuilder();
        topic.append(SHADOW_BASE);
        topic.append(options.getThingName());
        topic.append(SHADOW);
        if (shadowName != null && !shadowName.isEmpty()) {
            topic.append(NAME).append(shadowName);
        }
        topic.append(SLASH).append(action.name());
        if (result != null) {
            topic.append(SLASH).append(result.name());
        }
        return topic.toString();
    }

    private static final class MessageDispatcher
    implements Runnable {
        private final AwsIotMessageCallback callback;
        private final AwsIotMessage message;

        public MessageDispatcher(AwsIotMessageCallback callback, AwsIotMessage message) {
            this.callback = callback;
            this.message = message;
        }

        @Override
        public void run() {
            AwsIotMessageCallback callback = this.callback;
            assert (callback != null);
            AwsIotMessage message = this.message;
            assert (message != null);
            callback.onMessageReceived(message);
        }
    }
}

