/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.security;

import com.microej.kf.util.security.FeaturePolicyPermission;
import com.microej.kf.util.security.SecurityPolicyResourceLoader;
import ej.annotation.Nullable;
import ej.basictool.map.PackedMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;
import org.json.me.JSONTokener;

public class JsonSecurityPolicyLoader
implements SecurityPolicyResourceLoader {
    private static final Logger LOGGER = Logger.getLogger(JsonSecurityPolicyLoader.class.getName());

    @Nullable
    private List<FeaturePolicyPermission> loadResourceFile(@Nullable InputStream inputStream) {
        ArrayList<FeaturePolicyPermission> permissionList = new ArrayList<FeaturePolicyPermission>();
        if (inputStream == null) {
            LOGGER.fine("An installed feature came without security policy file");
            return null;
        }
        try {
            JSONTokener jsonTokener = new JSONTokener(inputStream);
            JSONObject rootPermissionObject = new JSONObject(jsonTokener).getJSONObject("permissions");
            for (String permissionClassName : rootPermissionObject.keySet()) {
                if (permissionClassName == null) continue;
                JSONObject permissionObject = rootPermissionObject.getJSONObject(permissionClassName);
                PackedMap nameActionsMap = new PackedMap();
                this.populateActions(permissionObject, (PackedMap<String, List<String>>)nameActionsMap);
                FeaturePolicyPermission policyPermission = new FeaturePolicyPermission(permissionClassName, (PackedMap<String, List<String>>)nameActionsMap);
                this.addToList(permissionList, policyPermission);
            }
        }
        catch (JSONException e) {
            LOGGER.severe("Error while parsing the policy security file: " + e.getMessage());
            return null;
        }
        return permissionList;
    }

    private void populateActions(JSONObject permissionObject, PackedMap<String, List<String>> nameActionsMap) throws JSONException {
        for (String param : permissionObject.keySet()) {
            if (param == null) continue;
            ArrayList<String> actionList = new ArrayList<String>();
            JSONArray actionArray = permissionObject.getJSONArray(param);
            for (String action : actionArray) {
                actionList.add(action);
            }
            nameActionsMap.put((Object)param, actionList);
        }
    }

    private void addToList(List<FeaturePolicyPermission> list, FeaturePolicyPermission policyPermission) {
        ArrayList<FeaturePolicyPermission> copy = new ArrayList<FeaturePolicyPermission>(list);
        if (copy.isEmpty()) {
            list.add(policyPermission);
            return;
        }
        boolean hasAlreadyBeenRegistered = false;
        for (FeaturePolicyPermission registeredPermission : copy) {
            if (!registeredPermission.getPermissionClassName().equals(policyPermission.getPermissionClassName())) continue;
            hasAlreadyBeenRegistered = true;
            break;
        }
        if (!hasAlreadyBeenRegistered) {
            list.add(policyPermission);
        }
    }

    @Override
    @Nullable
    public List<FeaturePolicyPermission> loadFeaturePermissions(@Nullable InputStream inputStream) {
        return this.loadResourceFile(inputStream);
    }
}

