/*
 * Decompiled with CFR 0.152.
 */
package ej.net.util.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class SslContextFactory {
    private SslContextFactory() {
    }

    public static SSLContext createSslContext(String protocol, TrustManager trustManager, KeyManager ... keyManagers) {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance(protocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            throw new UnsupportedOperationException(e);
        }
        return sslContext;
    }

    public static X509TrustManager createTrustManager(X509Certificate ... certificates) {
        TrustManagerFactory trustManagerFactory;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            int aliasId = 0;
            X509Certificate[] x509CertificateArray = certificates;
            int n = certificates.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate certificate = x509CertificateArray[n2];
                assert (certificate != null);
                String alias = Integer.toString(aliasId++);
                keyStore.setCertificateEntry(alias, certificate);
                ++n2;
            }
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new UnsupportedOperationException(e);
        }
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        TrustManager trustManager = trustManagers[0];
        assert (trustManager != null);
        return (X509TrustManager)trustManager;
    }

    public static X509KeyManager createKeyManager(byte[] key, char[] keyPassword, X509Certificate ... certificateChain) {
        KeyManagerFactory keyManagerFactory;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setKeyEntry("key", key, certificateChain);
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyPassword);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new UnsupportedOperationException(e);
        }
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        KeyManager keyManager = keyManagers[0];
        assert (keyManager != null);
        return (X509KeyManager)keyManager;
    }
}

