/*
 * Decompiled with CFR 0.152.
 */
package com.microej.android;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import com.microej.android.application.ApplicationDisplay;
import com.microej.android.application.ApplicationSupport;
import com.microej.android.internal.InternalDisplayListener;
import com.microej.android.internal.InternalSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MicroEJSupport {
    private static final String PROPERTIES_PATH = "/properties/merged.properties.list";
    private static Engine engine;

    private MicroEJSupport() {
    }

    public static ApplicationSupport getApplicationSupport() {
        return MicroEJSupport.getEngine();
    }

    public static InternalSupport getInternalSupport() {
        return MicroEJSupport.getEngine();
    }

    private static Engine getEngine() {
        if (engine == null) {
            engine = new Engine();
        }
        return engine;
    }

    private static class Engine
    implements ApplicationSupport,
    InternalSupport {
        private boolean isStarted;
        private Context context;
        private ApplicationDisplay display;
        private InternalDisplayListener displayListener;

        private Engine() {
        }

        @Override
        public void startup() {
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream inputStream = MicroEJSupport.class.getResourceAsStream(MicroEJSupport.PROPERTIES_PATH);){
                    if (inputStream != null) {
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        System.setProperties(properties);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setContext(Context context) {
            this.context = context;
        }

        @Override
        public void setDisplay(ApplicationDisplay display) {
            if (this.display != display) {
                this.display = display;
                this.onDisplayTearing(display);
            }
        }

        @Override
        public void unsetDisplay(ApplicationDisplay display) {
            if (this.display == display) {
                this.display = null;
            }
        }

        @Override
        public void onDisplayTearing(ApplicationDisplay display) {
            InternalDisplayListener displayListener;
            if (this.display == display && (displayListener = this.displayListener) != null) {
                displayListener.onTearing();
            }
        }

        @Override
        public void onPointerPress(ApplicationDisplay display, int x, int y) {
            InternalDisplayListener displayListener;
            if (this.display == display && (displayListener = this.displayListener) != null) {
                displayListener.onPointerPress(x, y);
            }
        }

        @Override
        public void onPointerRelease(ApplicationDisplay display) {
            InternalDisplayListener displayListener;
            if (this.display == display && (displayListener = this.displayListener) != null) {
                displayListener.onPointerRelease();
            }
        }

        @Override
        public void onPointerMove(ApplicationDisplay display, int x, int y) {
            InternalDisplayListener displayListener;
            if (this.display == display && (displayListener = this.displayListener) != null) {
                displayListener.onPointerMove(x, y);
            }
        }

        @Override
        public void checkStarted() {
            if (!this.isStarted) {
                throw new IllegalStateException("MicroEJ support engine not started");
            }
        }

        @Override
        public Context getContext() {
            if (this.context == null) {
                throw new IllegalStateException("Application context instance of MicroEJ support engine not set");
            }
            return this.context;
        }

        @Override
        public void flush(Bitmap bitmap, Rect rect) {
            if (this.display != null) {
                this.display.flush(bitmap, rect);
            }
        }

        @Override
        public void setDisplayListener(InternalDisplayListener displayListener) {
            this.displayListener = displayListener;
            if (this.display != null) {
                this.displayListener.onTearing();
            }
        }

        @Override
        public void unsetDisplayListener(InternalDisplayListener displayListener) {
            if (this.displayListener == displayListener) {
                this.displayListener = null;
            }
        }
    }
}

