/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.outline.border;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.microui.display.GraphicsContext;
import ej.mwt.style.outline.Outline;
import ej.mwt.style.outline.border.BorderHelper;
import ej.mwt.util.Outlineable;
import ej.mwt.util.Size;

public class FlexibleRectangularBorder
implements Outline {
    private final int color;
    private final char top;
    private final char bottom;
    private final char left;
    private final char right;

    public FlexibleRectangularBorder(int color, int top, int right, int bottom, int left) {
        this.color = color;
        this.top = (char)XMath.limit((int)top, (int)0, (int)65535);
        this.right = (char)XMath.limit((int)right, (int)0, (int)65535);
        this.bottom = (char)XMath.limit((int)bottom, (int)0, (int)65535);
        this.left = (char)XMath.limit((int)left, (int)0, (int)65535);
    }

    public int getColor() {
        return this.color;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    @Override
    public void apply(Outlineable outlineable) {
        outlineable.removeOutline(this.left, this.top, this.right, this.bottom);
    }

    @Override
    public void apply(GraphicsContext g, Size size) {
        int width = size.getWidth();
        int height = size.getHeight();
        char top = this.top;
        char bottom = this.bottom;
        char left = this.left;
        char right = this.right;
        g.setColor(this.color);
        BorderHelper.drawRectangularBorder(g, width, height, left, top, right, bottom);
        size.removeOutline(left, top, right, bottom);
        g.translate((int)left, (int)top);
        g.intersectClip(0, 0, size.getWidth(), size.getHeight());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof FlexibleRectangularBorder) {
            FlexibleRectangularBorder border = (FlexibleRectangularBorder)obj;
            return this.color == border.color && this.top == border.top && this.bottom == border.bottom && this.left == border.left && this.right == border.right;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 15 * this.color + this.top * this.bottom * this.left * this.right;
    }
}

