/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import ej.annotation.Nullable;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class ChunkedOutputStream
extends PrintStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final int CRLF_SIZE = CRLF.length;
    private static final byte[] FOOTER = CRLF;
    private static final int FOOTER_SIZE = CRLF_SIZE;
    private static final byte[] EMPTY_CHUNK_HEADER = ChunkedOutputStream.getHeader(0);
    private static final int EMPTY_CHUNK_HEADER_SIZE = ChunkedOutputStream.getHeaderSize(0);
    private final byte[] buf;
    private int size;
    private int count;
    private int spaceInCurrentChunk;
    @Nullable
    private PrintStream out;
    private int preferredChunkDataSize;
    private final int preferedHeaderSize;
    private final int preferredChunkGrossSize;
    private final byte[] completeHeader;

    private static int getHeaderSize(int size) {
        return Integer.toHexString(size).length() + CRLF_SIZE;
    }

    private static byte[] getHeader(int size) {
        try {
            String hexStr = Integer.toHexString(size);
            byte[] hexBytes = hexStr.getBytes("US-ASCII");
            byte[] header = new byte[ChunkedOutputStream.getHeaderSize(size)];
            int i = 0;
            while (i < hexBytes.length) {
                header[i] = hexBytes[i];
                ++i;
            }
            header[hexBytes.length] = CRLF[0];
            header[hexBytes.length + 1] = CRLF[1];
            return header;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ChunkedOutputStream(PrintStream o) {
        this(o, 4096);
    }

    public ChunkedOutputStream(PrintStream o, int size) {
        super(o);
        this.out = o;
        if (size <= 0) {
            size = 4096;
        }
        if (size > 0) {
            int adjusted_size = size - ChunkedOutputStream.getHeaderSize(size) - FOOTER_SIZE;
            if (ChunkedOutputStream.getHeaderSize(adjusted_size + 1) < ChunkedOutputStream.getHeaderSize(size)) {
                ++adjusted_size;
            }
            size = adjusted_size;
        }
        this.preferredChunkDataSize = size > 0 ? size : 4096 - ChunkedOutputStream.getHeaderSize(4096) - FOOTER_SIZE;
        this.preferedHeaderSize = ChunkedOutputStream.getHeaderSize(this.preferredChunkDataSize);
        this.preferredChunkGrossSize = this.preferedHeaderSize + this.preferredChunkDataSize + FOOTER_SIZE;
        this.completeHeader = ChunkedOutputStream.getHeader(this.preferredChunkDataSize);
        this.buf = new byte[this.preferredChunkDataSize + 32];
        this.reset();
    }

    private void flush(boolean flushAll) {
        PrintStream out = this.out;
        assert (out != null);
        if (this.spaceInCurrentChunk == 0) {
            out.write(this.buf, 0, this.preferredChunkGrossSize);
            out.flush();
            this.reset();
        } else if (flushAll) {
            if (this.size > 0) {
                int adjustedHeaderStartIndex = this.preferedHeaderSize - ChunkedOutputStream.getHeaderSize(this.size);
                System.arraycopy(ChunkedOutputStream.getHeader(this.size), 0, this.buf, adjustedHeaderStartIndex, ChunkedOutputStream.getHeaderSize(this.size));
                this.buf[this.count++] = FOOTER[0];
                this.buf[this.count++] = FOOTER[1];
                out.write(this.buf, adjustedHeaderStartIndex, this.count - adjustedHeaderStartIndex);
            } else {
                out.write(EMPTY_CHUNK_HEADER, 0, EMPTY_CHUNK_HEADER_SIZE);
            }
            out.flush();
            this.reset();
        }
    }

    @Override
    public boolean checkError() {
        return this.out.checkError();
    }

    private void ensureOpen() {
        if (this.out == null) {
            this.setError();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.ensureOpen();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int bytesToWrite = len;
        int inputIndex = off;
        do {
            if (bytesToWrite >= this.spaceInCurrentChunk) {
                int i = 0;
                while (i < this.completeHeader.length) {
                    this.buf[i] = this.completeHeader[i];
                    ++i;
                }
                System.arraycopy(b, inputIndex, this.buf, this.count, this.spaceInCurrentChunk);
                inputIndex += this.spaceInCurrentChunk;
                bytesToWrite -= this.spaceInCurrentChunk;
                this.count += this.spaceInCurrentChunk;
                this.buf[this.count++] = FOOTER[0];
                this.buf[this.count++] = FOOTER[1];
                this.spaceInCurrentChunk = 0;
                this.flush(false);
                if (!this.checkError()) continue;
                break;
            }
            System.arraycopy(b, inputIndex, this.buf, this.count, bytesToWrite);
            this.count += bytesToWrite;
            this.size += bytesToWrite;
            this.spaceInCurrentChunk -= bytesToWrite;
            bytesToWrite = 0;
        } while (bytesToWrite > 0);
    }

    @Override
    public synchronized void write(int _b) {
        byte[] b = new byte[]{(byte)_b};
        this.write(b, 0, 1);
    }

    public synchronized void reset() {
        this.count = this.preferedHeaderSize;
        this.size = 0;
        this.spaceInCurrentChunk = this.preferredChunkDataSize;
    }

    public int size() {
        return this.size;
    }

    @Override
    public synchronized void close() {
        this.ensureOpen();
        if (this.size > 0) {
            this.flush(true);
        }
        this.flush(true);
        this.out = null;
    }

    @Override
    public synchronized void flush() {
        this.ensureOpen();
        if (this.size > 0) {
            this.flush(true);
        }
    }
}

