/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.display;

import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImageFormat;
import ej.microvg.LLVGEngine;
import ej.microvg.MatrixHelper;
import ej.microvg.VGDrawing;
import ej.microvg.paint.TransformationVisitor;
import ej.microvg.paint.VGPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class DisplayDrawer
implements VGDrawing {
    @Override
    public MicroUIImageFormat handledFormat() {
        return LLUIDisplay.Instance.getDisplayFormat();
    }

    @Override
    public void drawPath(MicroUIGraphicsContext gc, GeneralPath path, float x, float y, float[] matrix, int fillRule, int blend, VGPaint paint) {
        LLVGEngine engine = LLVGEngine.Instance;
        path = (GeneralPath)path.clone();
        path.setWindingRule(engine.getFillRule(fillRule));
        AffineTransform translatedTransform = new AffineTransform();
        translatedTransform.translate(x, y);
        translatedTransform.concatenate(MatrixHelper.getAffineTransform(matrix, 0.0f, 0.0f));
        AffineTransform gradientMatrix = new AffineTransform();
        gradientMatrix.translate(x, y);
        BufferedImage bi = (BufferedImage)gc.getImage().getRAWImage();
        Graphics2D g2d = bi.createGraphics();
        engine.setClip(g2d, gc, path, translatedTransform);
        path.transform(translatedTransform);
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(paint.apply(new TransformationVisitor(gradientMatrix)).getPaint());
        g2d.setRenderingHints(rh);
        g2d.setComposite(engine.getComposite(blend));
        DisplayDrawer.fill(g2d, path);
        Rectangle bounds = g2d.getClipBounds();
        engine.convertColorToColorToDraw(gc, bounds);
    }

    private static void fill(Graphics2D g2d, GeneralPath path) {
        try {
            g2d.fill(path);
        }
        catch (Throwable throwable) {}
    }
}

