/*
 * Decompiled with CFR 0.152.
 */
package ej.microai;

import ej.microai.InputTensor;
import ej.microai.MLNatives;
import ej.microai.OutputTensor;
import ej.sni.SNI;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class MLInferenceEngine
implements Closeable {
    private static final int READ_CHUNK_SIZE = 4096;
    private final long modelHandle;
    private final long modelBuffer;
    private volatile boolean closed;
    private final int numberInputTensors;
    private final int numberOutputTensors;
    private final InputTensor[] inputTensors;
    private final OutputTensor[] outputTensors;

    public MLInferenceEngine(String modelPath, int inferenceMemoryPoolSize) {
        this.modelHandle = MLNatives.initModelFromResource(SNI.toCString((String)modelPath), inferenceMemoryPoolSize);
        this.modelBuffer = 0L;
        this.closed = false;
        this.numberInputTensors = MLNatives.getInputTensorCount(this.modelHandle);
        this.numberOutputTensors = MLNatives.getOutputTensorCount(this.modelHandle);
        this.inputTensors = new InputTensor[this.numberInputTensors];
        this.outputTensors = new OutputTensor[this.numberOutputTensors];
    }

    public MLInferenceEngine(InputStream is, int inferenceMemoryPoolSize) throws IOException {
        int bytesRead;
        this.modelBuffer = MLNatives.allocateModel(is.available());
        byte[] modelData = new byte[4096];
        int totalBytesRead = 0;
        while ((bytesRead = is.read(modelData, 0, 4096)) != -1) {
            MLNatives.loadModelChunk(modelData, this.modelBuffer, totalBytesRead, bytesRead);
            totalBytesRead += bytesRead;
        }
        this.modelHandle = MLNatives.initModelFromBuffer(this.modelBuffer, totalBytesRead, inferenceMemoryPoolSize);
        this.closed = false;
        this.numberInputTensors = MLNatives.getInputTensorCount(this.modelHandle);
        this.numberOutputTensors = MLNatives.getOutputTensorCount(this.modelHandle);
        this.inputTensors = new InputTensor[this.numberInputTensors];
        this.outputTensors = new OutputTensor[this.numberOutputTensors];
    }

    public int reset() {
        return MLNatives.reset(this.modelHandle);
    }

    public int run() {
        return MLNatives.run(this.modelHandle);
    }

    public InputTensor getInputTensor(int index) {
        if (index >= this.numberInputTensors) {
            throw new IllegalArgumentException("Input index " + index + " out of range (length is " + this.numberInputTensors + ")");
        }
        if (this.inputTensors[index] == null) {
            this.inputTensors[index] = new InputTensor(this.modelHandle, index);
        }
        return this.inputTensors[index];
    }

    public OutputTensor getOutputTensor(int index) {
        if (index >= this.numberOutputTensors) {
            throw new IllegalArgumentException("Output index " + index + " out of range (length is " + this.numberOutputTensors + ")");
        }
        if (this.outputTensors[index] == null) {
            this.outputTensors[index] = new OutputTensor(this.modelHandle, index);
        }
        return this.outputTensors[index];
    }

    public int getInputTensorCount() {
        return this.numberInputTensors;
    }

    public int getOutputTensorCount() {
        return this.numberOutputTensors;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        MLNatives.clean(this.modelHandle);
        MLNatives.freeModel(this.modelBuffer);
    }
}

