/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tools.eclipseplugin.wizard;

import com.microej.tools.eclipseplugin.Activator;
import com.microej.tools.eclipseplugin.wizard.JavaClasspathSetter;
import com.microej.tools.eclipseplugin.wizard.MicroEjClasspathSetter;
import com.microej.tools.eclipseplugin.wizard.NewApplicationWizard;
import com.microej.tools.eclipseplugin.wizard.NewMicroEjProjectConfigurationPage;
import com.microej.tools.eclipseplugin.wizard.TemplateFile;
import com.microej.tools.eclipseplugin.wizard.TemplateProcessor;
import java.io.File;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.operation.ToolingApiJobResultHandler;
import org.eclipse.buildship.core.internal.workspace.SynchronizationJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class NewMicroEjProjectWizard
extends Wizard
implements INewWizard {
    private NewMicroEjProjectConfigurationPage configurationPage;

    public NewMicroEjProjectWizard(String windowTitle, String imageDescriptor) {
        this.setWindowTitle(windowTitle);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor(imageDescriptor));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.configurationPage = this.newConfigurationPage();
        super.addPage((IWizardPage)this.configurationPage);
    }

    protected abstract NewMicroEjProjectConfigurationPage newConfigurationPage();

    public boolean performFinish() {
        String projectName = this.configurationPage.getProjectName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        try {
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
            project.create(projectDescription, null);
            project.open(null);
            NewMicroEjProjectWizard.addJavaNature(project);
            GradleBuild build = this.createGradleFiles(project);
            SynchronizationJob job = new SynchronizationJob(build);
            job.setResultHandler((ToolingApiJobResultHandler)this.newClasspathSetter(project));
            job.schedule();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected JavaClasspathSetter newClasspathSetter(IProject project) {
        return new MicroEjClasspathSetter(project);
    }

    public abstract String getModuleType();

    public abstract String getSampleClassName();

    public abstract String getSampleTemplate();

    private GradleBuild createGradleFiles(IProject project) {
        String projectName = this.configurationPage.getProjectName();
        String groupName = this.configurationPage.getProjectOrganization();
        String moduleName = this.configurationPage.getProjectModule();
        String version = this.configurationPage.getProjectRevision();
        boolean isKernelApp = this.configurationPage.isKernelApplication();
        try {
            TemplateProcessor templateProcessor = new TemplateProcessor();
            TemplateFile settingsFile = templateProcessor.getTemplate("microej-settings-gradle.ft");
            settingsFile.replace("projectName", projectName);
            settingsFile.create(project, "settings.gradle.kts");
            TemplateFile buildFile = templateProcessor.getTemplate("microej-build-gradle.ft");
            buildFile.replace("pluginType", this.getModuleType());
            buildFile.replace("pluginVersion", "1.5.0");
            buildFile.replace("version", version);
            buildFile.replace("groupName", groupName);
            buildFile.replace("moduleName", moduleName);
            buildFile.replace("isKernel", Boolean.toString(isKernelApp));
            buildFile.create(project, "build.gradle.kts");
            if (!this.getModuleType().equals("runtime-environment")) {
                IFolder srcJavaFolder = project.getFolder("src/main/java");
                IFolder groupFolder = srcJavaFolder.getFolder(this.configurationPage.getProjectOrganization().replaceAll("\\.", "/"));
                this.createFolder(groupFolder);
                IFolder sampleFolder = groupFolder.getFolder(this.configurationPage.getProjectModule());
                this.createFolder(sampleFolder);
                String sampleFile = this.getSampleTemplate();
                if (sampleFile != null) {
                    TemplateFile javaSample = templateProcessor.getTemplate(this.getSampleTemplate());
                    javaSample.replace("pluginType", this.getModuleType());
                    javaSample.replace("groupName", groupName);
                    javaSample.replace("moduleName", moduleName);
                    javaSample.replace("isKernel", Boolean.toString(isKernelApp));
                    javaSample.create(sampleFolder, this.getSampleClassName());
                }
                IFolder srcTestFolder = project.getFolder("src/test/java");
                IFolder srcResourcesFolder = project.getFolder("src/main/resources");
                IFolder srcTestResourcesFolder = project.getFolder("src/test/resources");
                this.createFolder(srcTestFolder);
                this.createFolder(srcResourcesFolder);
                this.createFolder(srcTestResourcesFolder);
            }
            TemplateFile readme = templateProcessor.getTemplate("readme.ft");
            readme.replace("pluginType", this.getModuleType());
            readme.replace("moduleName", moduleName);
            readme.create(project, "README.md");
            this.copyResource("LICENSE.txt", project);
            this.copyResource("CHANGELOG.md", project);
            if (this.getModuleType().equals("application")) {
                IFolder configurationFolder = project.getFolder("configuration");
                this.copyResource("common.properties", configurationFolder);
            }
            IFolder wrapperFolder = project.getFolder("gradle/wrapper");
            this.copyResource("gradle-wrapper.properties", wrapperFolder);
            BuildConfiguration.BuildConfigurationBuilder configBuilder = BuildConfiguration.forRootProjectDirectory((File)project.getLocation().toFile());
            configBuilder.gradleDistribution((GradleDistribution)GradleDistribution.fromBuild());
            BuildConfiguration buildConfig = configBuilder.build();
            return GradleCore.getWorkspace().createBuild(buildConfig);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().error("An error occured while creating Gradle project");
            e.printStackTrace();
            return null;
        }
    }

    private void copyResource(String resourceName, IProject project) throws CoreException {
        this.copyResource(resourceName, project.getFile(resourceName));
    }

    private void copyResource(String resourceName, IFolder targetFolder) throws CoreException {
        this.createFolder(targetFolder);
        this.copyResource(resourceName, targetFolder.getFile(resourceName));
    }

    private void copyResource(String resourceName, IFile targetFile) throws CoreException {
        targetFile.create(NewApplicationWizard.class.getResourceAsStream("/" + resourceName), true, null);
    }

    private void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    private static void addJavaNature(IProject project) throws CoreException {
        String[] natures;
        IProjectDescription description = project.getDescription();
        String[] stringArray = natures = description.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if ("org.eclipse.jdt.core.javanature".equals(nature)) {
                return;
            }
            ++n2;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }
}

