/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tools.eclipseplugin.jdk;

import com.microej.tools.eclipseplugin.Activator;
import com.microej.tools.eclipseplugin.jdk.ProjectClasspathManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;

public class ClasspathChangeListener
implements IElementChangedListener {
    private final ProjectClasspathManager projectClasspathManager;

    public ClasspathChangeListener(ProjectClasspathManager projectClasspathManager) {
        this.projectClasspathManager = projectClasspathManager;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        this.processDelta(delta);
    }

    private void processDelta(IJavaElementDelta delta) {
        if (delta.getElement() instanceof IJavaProject) {
            final IJavaProject javaProject = (IJavaProject)delta.getElement();
            if (this.classpathHasChanged(delta) || this.projectIsOpened(delta)) {
                Activator.getDefault().getLog().info("Project is opened or classpath has changed, triggering the removal of the JRE classpath entry.");
                Job job = new Job("Classpath Modification Job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        ClasspathChangeListener.this.projectClasspathManager.removeJreContainer(javaProject.getProject());
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                job.schedule();
            }
        }
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.processDelta(child);
            ++n2;
        }
    }

    private boolean classpathHasChanged(IJavaElementDelta delta) {
        return (delta.getFlags() & 0x20000) != 0;
    }

    private boolean projectIsOpened(IJavaElementDelta delta) {
        return (delta.getFlags() & 0x200) != 0;
    }
}

