/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tools.eclipseplugin.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class NewMicroEjProjectConfigurationPage
extends WizardPage
implements ISelectionChangedListener,
Listener {
    protected Composite container;
    private Text txtProjectName;
    private Text txtOrganizationName;
    private Text txtModuleName;
    private boolean txtModuleNameEdited;
    private Text txtRevisionName;
    List<IStatus> pageStatuses;
    private final Map<Text, String> textMapping;

    public NewMicroEjProjectConfigurationPage(String title, String description) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
        this.textMapping = new HashMap<Text, String>();
        this.pageStatuses = new ArrayList<IStatus>();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gridData = new GridData(4, 4, true, false);
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)gridData);
        this.createLabelField("Project:");
        this.txtProjectName = this.createTextField("Project name", "");
        this.createLabelField("");
        this.createLabelField("Publication :");
        this.txtOrganizationName = this.createTextField("Organization", "com.mycompany");
        this.txtModuleName = this.createTextField("Module", "");
        this.txtRevisionName = this.createTextField("Revision", "0.1.0-RC");
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMicroEjProjectConfigurationPage.this.updateProjectName();
            }
        });
        this.txtModuleName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMicroEjProjectConfigurationPage.this.updateModuleName();
            }
        });
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void updateProjectName() {
        String projectName = this.txtProjectName.getText();
        if (!this.txtModuleNameEdited) {
            this.txtModuleName.setText(projectName.replaceAll("[^a-zA-Z0-9_]", "_"));
        }
    }

    private void updateModuleName() {
        String projectName = this.txtProjectName.getText().replaceAll("[^a-zA-Z0-9_]", "_");
        this.txtModuleNameEdited = !projectName.equals(this.txtModuleName.getText());
    }

    public void handleEvent(Event e) {
        this.checkPage();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.checkPage();
    }

    public String getProjectName() {
        return this.txtProjectName.getText();
    }

    public String getProjectOrganization() {
        return this.txtOrganizationName.getText();
    }

    public String getProjectModule() {
        return this.txtModuleName.getText();
    }

    public String getProjectRevision() {
        return this.txtRevisionName.getText();
    }

    public abstract boolean isKernelApplication();

    private void checkPage() {
        this.pageStatuses.clear();
        this.pageStatuses.add((IStatus)new Status(0, "not_used", ""));
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Text txtField;
            String textValue;
            Control control = controlArray[n2];
            if (Text.class.isAssignableFrom(control.getClass()) && (textValue = (txtField = (Text)control).getText().trim()).isEmpty()) {
                this.pageStatuses.add((IStatus)new Status(4, "not_used", String.valueOf(this.textMapping.get(txtField)) + " is empty."));
            }
            ++n2;
        }
        String projectName = this.txtProjectName.getText().trim();
        if (!projectName.isEmpty() && ResourcesPlugin.getWorkspace().getRoot().exists(Path.fromOSString((String)projectName))) {
            this.pageStatuses.add((IStatus)new Status(4, "not_used", "Project already exists."));
        }
        this.updatePageStatus();
    }

    private void updatePageStatus() {
        IStatus mostSevereStatus = this.getMostSevereStatus();
        String message = mostSevereStatus.getMessage();
        if (message.isEmpty()) {
            message = null;
        }
        switch (mostSevereStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                this.setPageComplete(true);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                this.setPageComplete(true);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                this.setPageComplete(true);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
                this.setPageComplete(false);
            }
        }
        this.getWizard().getContainer().updateButtons();
    }

    private IStatus getMostSevereStatus() {
        IStatus mostSevereStatus = null;
        for (IStatus status : this.pageStatuses) {
            if (mostSevereStatus != null && mostSevereStatus.getSeverity() >= status.getSeverity()) continue;
            mostSevereStatus = status;
        }
        return mostSevereStatus;
    }

    private Label createLabelField(String label) {
        Label labelField = new Label(this.container, 256);
        labelField.setText(label);
        FontData fontData = labelField.getFont().getFontData()[0];
        Font font = new Font((Device)this.getShell().getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
        labelField.setFont(font);
        this.createLabel("");
        return labelField;
    }

    private Text createTextField(String label, String text) {
        this.createLabel(String.valueOf(label) + " :");
        Text textField = new Text(this.container, 2052);
        textField.setText(text);
        textField.setLayoutData((Object)new GridData(4, 1, true, false));
        textField.addListener(24, (Listener)this);
        this.textMapping.put(textField, label);
        return textField;
    }

    protected void createLabel(String label) {
        Label labelField = new Label(this.container, 256);
        labelField.setText(label);
    }
}

