/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tools.eclipseplugin.jdk;

import com.microej.tools.eclipseplugin.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;

public class ProjectClasspathManager {
    public void removeJreContainer(IProject project) {
        this.removeJreContainer(project, null);
    }

    public void removeJreContainer(IProject project, IProgressMonitor monitor) {
        try {
            if (!this.isJavaProject(project) || !this.isMicroejProject(project)) {
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null) {
                return;
            }
            ArrayList<IClasspathEntry> classpath = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
            ListIterator iterator = classpath.listIterator();
            while (iterator.hasNext()) {
                IClasspathEntry entry = (IClasspathEntry)iterator.next();
                String containerType = entry.getPath().segment(0);
                if (!JavaRuntime.JRE_CONTAINER.equals(containerType)) continue;
                Activator.getDefault().getLog().info("JRE classpath entry found in a Gradle project, removing it.");
                iterator.remove();
            }
            javaProject.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), monitor);
        }
        catch (JavaModelException e) {
            Activator.getDefault().getLog().error("Error when trying to remove the JRE classpath entry of the project " + project, (Throwable)e);
        }
    }

    public List<IProject> getGradleProjects() {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.isOpen() && this.isJavaProject(project) && this.isGradleProject(project)) {
                projectList.add(project);
            }
            ++i;
        }
        return projectList;
    }

    public List<IProject> getMicroejProjects() {
        List<IProject> gradleProjectList = this.getGradleProjects();
        ArrayList<IProject> microejProjectList = new ArrayList<IProject>();
        for (IProject project : gradleProjectList) {
            if (!this.isMicroejProject(project)) continue;
            microejProjectList.add(project);
        }
        return microejProjectList;
    }

    private boolean isJavaProject(IProject project) {
        boolean isJavaProject = false;
        try {
            isJavaProject = project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().error("Error when checking if the project " + project + " is a Java project (considered has a non-Java project):", (Throwable)e);
        }
        return isJavaProject;
    }

    private boolean isGradleProject(IProject project) {
        boolean isGradleProject = false;
        try {
            isGradleProject = project.hasNature("org.eclipse.buildship.core.gradleprojectnature");
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().error("Error when checking if the project " + project + " is a Gradle project (considered has a non-Gradle project):", (Throwable)e);
        }
        return isGradleProject;
    }

    private boolean isMicroejProject(IProject project) {
        if (!this.isGradleProject(project)) {
            return false;
        }
        try {
            GradleBuild build = (GradleBuild)GradleCore.getWorkspace().getBuild(project).get();
            GradleProject model = (GradleProject)build.withConnection(connection -> (GradleProject)connection.getModel(GradleProject.class), null);
            if (!this.getMicroejTasks(model).isEmpty()) {
                return !this.isMicroejJavaSeProject(model);
            }
            return model.getChildren().stream().anyMatch(subProject -> subProject.getName().equals(project.getName()) && !this.isMicroejJavaSeProject((GradleProject)subProject));
        }
        catch (Exception e) {
            System.err.println("Cannot query Gradle model: " + e.getMessage());
            return false;
        }
    }

    private List<? extends GradleTask> getMicroejTasks(GradleProject project) {
        return project.getTasks().stream().filter(task -> task.getGroup() != null && task.getGroup().equals("MicroEJ")).collect(Collectors.toList());
    }

    private boolean isMicroejJavaSeProject(GradleProject project) {
        return project.getTasks().stream().noneMatch(task -> task.getName().equals("loadVee") || task.getName().equals("buildRuntimeEnvironmentJar") || task.getName().equals("buildRuntimeApiJar"));
    }
}

