/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.stylesheet.cascading;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.bon.Constants;
import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.style.EditableStyle;
import ej.mwt.style.Style;
import ej.mwt.stylesheet.Stylesheet;
import ej.mwt.stylesheet.cascading.CascadingStyle;
import ej.mwt.stylesheet.selector.Selector;
import java.util.Map;
import java.util.WeakHashMap;

public class CascadingStylesheet
implements Stylesheet {
    public static final int DIMENSION_INDEX = 0;
    public static final int HORIZONTAL_ALIGNMENT_INDEX = 1;
    public static final int VERTICAL_ALIGNMENT_INDEX = 2;
    public static final int MARGIN_INDEX = 3;
    public static final int BORDER_INDEX = 4;
    public static final int PADDING_INDEX = 5;
    public static final int BACKGROUND_INDEX = 6;
    public static final int COLOR_INDEX = 7;
    public static final int FONT_INDEX = 8;
    public static final int EXTRA_FIELD_1_INDEX = 9;
    public static final int EXTRA_FIELD_2_INDEX = 10;
    public static final int EXTRA_FIELD_3_INDEX = 11;
    public static final int EXTRA_FIELD_4_INDEX = 12;
    public static final int EXTRA_FIELD_5_INDEX = 13;
    public static final int EXTRA_FIELD_6_INDEX = 14;
    public static final int EXTRA_FIELD_7_INDEX = 15;
    public static final String DEBUG_CASCADINGSTYLE_ENABLED_CONSTANT = "ej.mwt.debug.cascadingstyle.enabled";
    private static final int FIELDS_COUNT = 16;
    private static final Map<CascadingStyle, Selector[]> styleSources = new WeakHashMap<CascadingStyle, Selector[]>();
    private static Selector[] currentSelectors;
    private EditableStyle defaultStyle = new EditableStyle();
    private Object[] selectorStyles = new Object[0];

    @Override
    public Style getStyle(Widget widget) {
        CascadingStyle resultingStyle = new CascadingStyle(this.defaultStyle);
        if (Constants.getBoolean((String)DEBUG_CASCADINGSTYLE_ENABLED_CONSTANT)) {
            CascadingStylesheet.createCurrentStyleSources();
        }
        this.mergeSelectors(widget, resultingStyle);
        Container parentWidget = widget.getParent();
        if (parentWidget != null) {
            Style parentStyle = parentWidget.getStyle();
            resultingStyle.inheritMerge(parentStyle);
            if (Constants.getBoolean((String)DEBUG_CASCADINGSTYLE_ENABLED_CONSTANT)) {
                this.updateSource(resultingStyle, parentStyle);
            }
        }
        resultingStyle.updateHashCode();
        if (Constants.getBoolean((String)DEBUG_CASCADINGSTYLE_ENABLED_CONSTANT)) {
            styleSources.put(resultingStyle, currentSelectors);
        }
        return resultingStyle;
    }

    private void mergeSelectors(Widget widget, CascadingStyle resultingStyle) {
        Object[] selectorStyles = this.selectorStyles;
        int i = 0;
        while (i < selectorStyles.length) {
            if (((Selector)selectorStyles[i]).appliesToWidget(widget)) {
                CascadingStyle style = (CascadingStyle)selectorStyles[i + 1];
                assert (style != null);
                resultingStyle.merge(style);
                if (Constants.getBoolean((String)DEBUG_CASCADINGSTYLE_ENABLED_CONSTANT)) {
                    this.updateSource(style, (Selector)selectorStyles[i]);
                }
            }
            i += 2;
        }
    }

    public EditableStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public void resetDefaultStyle() {
        this.defaultStyle = new EditableStyle();
    }

    public EditableStyle getSelectorStyle(Selector selector) {
        Object[] selectorStyles = this.selectorStyles;
        int selectorIndex = CascadingStylesheet.getSelectorIndex(selector, selectorStyles);
        if (selectorIndex != -1) {
            CascadingStyle style = (CascadingStyle)selectorStyles[selectorIndex + 1];
            assert (style != null);
            return style;
        }
        CascadingStyle style = new CascadingStyle();
        int index = CascadingStylesheet.getIndex(selector, selectorStyles);
        selectorStyles = ArrayTools.grow((Object[])selectorStyles, (int)index, (int)2);
        selectorStyles[index] = selector;
        selectorStyles[index + 1] = style;
        this.selectorStyles = selectorStyles;
        return style;
    }

    public void resetSelectorStyle(Selector selector) {
        Object[] selectorStyles = this.selectorStyles;
        int selectorIndex = CascadingStylesheet.getSelectorIndex(selector, selectorStyles);
        if (selectorIndex != -1) {
            this.selectorStyles = ArrayTools.shrink((Object[])selectorStyles, (int)selectorIndex, (int)2);
        }
    }

    public void reset() {
        this.defaultStyle = new EditableStyle();
        this.selectorStyles = new Object[0];
    }

    private static int getIndex(Selector selector, Object[] selectorStyles) {
        int specificity = selector.getSpecificity();
        int minIndex = 0;
        int maxIndex = selectorStyles.length / 2;
        while (maxIndex - minIndex > 1) {
            int currentIndex = (maxIndex - minIndex) / 2 + minIndex;
            if (CascadingStylesheet.isMoreSpecific(selectorStyles, currentIndex * 2, specificity)) {
                minIndex = currentIndex;
                continue;
            }
            maxIndex = currentIndex;
        }
        if (maxIndex > minIndex) {
            if (CascadingStylesheet.isMoreSpecific(selectorStyles, minIndex * 2, specificity)) {
                return maxIndex * 2;
            }
            return minIndex * 2;
        }
        return minIndex * 2;
    }

    private static boolean isMoreSpecific(Object[] selectorStyles, int index, int specificity) {
        int specificityCandidate = ((Selector)selectorStyles[index]).getSpecificity();
        return specificityCandidate > specificity;
    }

    private static int getSelectorIndex(Selector selector, Object[] selectorStyles) {
        int i = 0;
        while (i < selectorStyles.length) {
            if (selector.equals(selectorStyles[i])) {
                return i;
            }
            i += 2;
        }
        return -1;
    }

    private static void createCurrentStyleSources() {
        currentSelectors = new Selector[16];
    }

    private void updateSource(CascadingStyle style, Selector selector) {
        Selector[] sources = currentSelectors;
        assert (sources != null);
        short styleMap = style.map;
        int i = 0;
        while (i < 16) {
            this.updateSource(styleMap, sources, selector, i);
            ++i;
        }
    }

    private void updateSource(CascadingStyle style, Style fromStyle) {
        Selector[] fromSources = CascadingStylesheet.getStyleSources(fromStyle);
        if (fromSources != null) {
            Selector[] sources = currentSelectors;
            assert (sources != null);
            short styleMap = style.map;
            int i = 0;
            while (i < 16) {
                this.updateSource(styleMap, sources, fromSources[i], i);
                ++i;
            }
        }
    }

    private void updateSource(short styleMap, Selector[] sources, Selector selector, int field) {
        if (sources[field] == null && (styleMap & 1 << field) != 0) {
            sources[field] = selector;
        }
    }

    @Nullable
    public static Selector[] getStyleSources(Style style) {
        if (style instanceof CascadingStyle) {
            return styleSources.get(style);
        }
        throw new IllegalArgumentException();
    }
}

