/*
 * Copyright 2015-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet.selector;

import ej.annotation.Nullable;
import ej.mwt.Widget;

/**
 * A not selector selects every widget that is not selected by its wrapped selector.
 * <p>
 * Equivalent to <code>:not()</code> selector in CSS. Its specificity is the same as its wrapped selector.
 *
 * @see SelectorHelper
 */
public class NotSelector implements Selector {

	private final Selector selector;

	/**
	 * Creates a not selector.
	 *
	 * @param selector
	 *            the wrapped selector.
	 */
	public NotSelector(Selector selector) {
		this.selector = selector;
	}

	@Override
	public boolean appliesToWidget(Widget widget) {
		return !this.selector.appliesToWidget(widget);
	}

	@Override
	public int getSpecificity() {
		return this.selector.getSpecificity();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		if (obj != null && getClass() == obj.getClass()) {
			NotSelector other = (NotSelector) obj;
			return this.selector.equals(other.selector);
		}
		return false;
	}

	@Override
	public int hashCode() {
		return this.selector.hashCode();
	}
}
