/*
 * Java
 *
 * Copyright 2015-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.display;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * This class is for font permissions.
 * <p>
 * The name is related to the font APIs and it symbolizes the permission's action.
 * <p>
 * The meaning of the possible permissions is defined as follows:
 * <dl>
 * <dt>add
 * <dd>add permission. Permission is checked when fonts are added to the system during the initialization process.
 * </dl>
 *
 * @see java.security.Permission
 *
 * @since 2.0
 */
public class FontPermission extends Permission {

	/**
	 * @deprecated use {@link #FontPermission(String)}
	 */
	@Deprecated
	public FontPermission() {
		super(null);
		throw new RuntimeException();
	}

	/**
	 * Creates a permission with the specified name.
	 *
	 * @param permission
	 *            the name of the <code>FontPermission</code>.
	 */
	public FontPermission(String permission) {
		super(permission);
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
