/*
 * Java
 *
 * Copyright 2015-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * This class is for MicroUI permissions.
 * <p>
 * The name is related to the MicroUI APIs and it symbolizes the permission's action.
 * <p>
 * The meaning of the possible permissions is defined as follows:
 * <dl>
 * <dt>start
 * <dd>start permission. Allows <code>MicroUI.start()</code> to be called.
 * <dt>stop
 * <dd>stop permission. Allows <code>MicroUI.stop()</code> to be called.
 * </dl>
 *
 * @see java.security.Permission
 */
public class MicroUIPermission extends Permission {

	/**
	 * Permission to start MicroUI.
	 */
	public static final String ACTION_START = "start"; //$NON-NLS-1$

	/**
	 * Permission to stop MicroUI.
	 */
	public static final String ACTION_STOP = "stop"; //$NON-NLS-1$

	/**
	 * Creates a permission with the specified name.
	 *
	 * @param permission
	 *            the name of the <code>MicroUIPermission</code>.
	 */
	public MicroUIPermission(String permission) {
		super(null);
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
