/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIFontFormat;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImage;
import ej.microui.display.MicroUIImageFormat;
import ej.microvg.MicroVGImage;
import ej.microvg.VGDrawing;
import ej.microvg.bvi.BufferedVectorImageDrawer;
import ej.microvg.paint.VGPaint;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ServiceLoader;

public interface LLVGEngine {
    public static final MicroUIImageFormat BUFFERED_VECTOR_IMAGE_FORMAT = MicroUIImageFormat.MICROUI_IMAGE_FORMAT_CUSTOM_7;
    public static final MicroUIFontFormat VECTOR_FONT_FORMAT = MicroUIFontFormat.MICROUI_FONT_FORMAT_CUSTOM_7;
    public static final int DEFAULT_LETTER_SPACING = 0;
    public static final LLVGEngine Instance = ServiceLoader.load(LLVGEngine.class, LLVGEngine.class.getClassLoader()).iterator().next();

    public void registerVGDrawer(VGDrawing var1);

    public void unregisterVGDrawer(MicroUIImageFormat var1);

    public VGDrawing getVGDrawer(MicroUIGraphicsContext var1);

    public VGDrawing getVGDrawer(MicroUIImageFormat var1);

    public GeneralPath mapPath(byte[] var1);

    public VGPaint mapGradient(int[] var1, float[] var2, float[] var3, int var4);

    public MicroVGImage mapVectorImage(byte[] var1);

    public void setClip(Graphics2D var1, MicroUIGraphicsContext var2, GeneralPath var3, AffineTransform var4);

    public int getFillRule(int var1);

    public Composite getComposite(int var1);

    public int drawString(MicroUIGraphicsContext var1, char[] var2, int var3, float var4, float var5, float var6, float[] var7, int var8, VGPaint var9, float var10, float var11, int var12);

    default public void convertColorToColorToDraw(MicroUIGraphicsContext gc, Rectangle2D bounds) {
        LLUIDisplay d = LLUIDisplay.Instance;
        d.convertRegion((MicroUIImage)gc, (int)bounds.getMinX(), (int)bounds.getMinY(), (int)bounds.getWidth(), (int)bounds.getHeight());
    }

    public BufferedVectorImageDrawer getBufferedVectorImageDrawer();
}

