/*
 * Java
 *
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.image.pathdata;

import java.nio.ByteBuffer;

/**
 * Decodes a path whose data is stored in only one byte array: CMD0, CMD_DATA0, CMD_DATA1, CMD1, CMD_DATA0, CMD_DATA1,
 * etc. The command and command's attributes are encoded in float or signed 8-16-32 bits.
 */
public abstract class SingleArrayPathData implements PathData {

	/**
	 * The encoded path.
	 */
	protected final ByteBuffer buffer; // used by sub-classes

	/**
	 * Creates a decoder that will decode the path encoded in a single byte array.
	 *
	 * @param buffer
	 *            the encoded path (the first available data is the first path's command)
	 */
	protected SingleArrayPathData(ByteBuffer buffer) {
		this.buffer = buffer;
	}

	@Override
	public boolean hasRemainingCommand() {
		return this.buffer.hasRemaining();
	}

}
