/*
 * Java
 *
 * Copyright 2023-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg;

import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.paint.PaintVisitor;

/**
 * Represents an encoded static or dynamic vector image.
 */
public interface MicroVGImage {

	/**
	 * Returns a unique identifier for the image.
	 * <p>
	 * The identifier is reserved for this image until it is closed. It can be assimilated to the image buffer address
	 * (see LLUI_DISPLAY_getBufferAddress() on emb side).
	 *
	 * @return an integer useful to identify an image
	 */
	int getIdentifier();

	/**
	 * Draws an image with transformation and opacity. Optionally apply an animation and / or a color filtering.
	 *
	 * @param gc
	 *            the graphics context to draw on
	 * @param matrix
	 *            the transformation matrix to apply
	 * @param alpha
	 *            the global opacity rendering value
	 * @param elapsedTime
	 *            the elapsed time since the beginning of the animation, in milliseconds
	 * @param colorMatrix
	 *            the color matrix used to transform colors
	 * @return a VectorGraphicsException error code
	 */
	int draw(MicroUIGraphicsContext gc, float[] matrix, int alpha, long elapsedTime, float[] colorMatrix);

	/**
	 * Transforms the image with the given transformer.
	 *
	 * @param transformer
	 *            the transformer to apply
	 * @return a transformed copy of the image
	 */
	MicroVGImage transform(PaintVisitor transformer);
}
