/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.security;

import com.microej.kf.util.security.FeaturePermissionCheckDelegate;
import ej.kf.Feature;
import ej.kf.Kernel;
import java.security.Permission;
import java.util.HashMap;

public class KernelSecurityManager
extends SecurityManager {
    private final HashMap<Class<? extends Permission>, FeaturePermissionCheckDelegate> permissionsMap = new HashMap();

    public void setFeaturePermissionDelegate(Class<? extends Permission> permission, FeaturePermissionCheckDelegate delegate) {
        this.permissionsMap.put(permission, delegate);
    }

    @Override
    public void checkPermission(Permission perm) {
        if (!Kernel.isInKernelMode()) {
            Feature f = (Feature)Kernel.getContextOwner();
            Kernel.enter();
            FeaturePermissionCheckDelegate fp = this.permissionsMap.get(perm.getClass());
            if (fp != null) {
                fp.checkPermission(perm, f);
            } else {
                this.unknownPermission(perm);
            }
        }
    }

    protected void unknownPermission(Permission perm) {
        throw new SecurityException();
    }
}

