/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.policy;

import com.microej.kf.util.control.fs.FileSystemResourcesController;
import com.microej.kf.util.control.net.Bandwidth;
import com.microej.kf.util.control.net.NetResourcesController;
import com.microej.kf.util.control.net.Subnet;
import com.microej.kf.util.module.SandboxedModule;
import com.microej.kf.util.module.SandboxedModuleHelper;
import com.microej.kf.util.policy.FeaturePolicySchema;
import ej.kf.Feature;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.service.ServiceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;
import org.json.me.JSONTokener;

public class FeaturePolicyEnforcer {
    private int threadPriority = 5;
    private static final String POLICY_PROPERTY = "feature.policy.name";
    private static final String POLICY_FILE_NAME = "feature.policy.json";
    private static final int QUOTA_PERCENTAGE_RATIO = Integer.getInteger("monitoring.check.cpu.calibration", 100000);
    private static final Logger LOGGER = Logger.getLogger(FeaturePolicyEnforcer.class.getName());

    public void applyPolicy(Feature app) throws JSONException, IOException {
        String resourceFileName;
        if (System.getProperty("monitoring.check.cpu.calibration") == null && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "Property monitoring.check.cpu.calibration is not set. Running with default value: " + QUOTA_PERCENTAGE_RATIO);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Loading policy file for app " + app.getName());
        }
        String resourceFilePath = (resourceFileName = System.getProperty(POLICY_PROPERTY, POLICY_FILE_NAME)).startsWith("/") ? resourceFileName : "/" + resourceFileName;
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream inputStream = app.getResourceAsStream(resourceFilePath);){
            if (inputStream == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Policy file was not found at: " + resourceFilePath);
                }
                return;
            }
            this.loadResourceFile(inputStream, app);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void loadResourceFile(InputStream inputStream, Feature app) throws JSONException, IOException {
        JSONObject resources;
        JSONTokener jsonTokener = new JSONTokener(inputStream);
        JSONObject rootObject = new JSONObject(jsonTokener);
        this.threadPriority = rootObject.optInt(FeaturePolicySchema.PRIORITY.toString(), 5);
        int criticality = rootObject.optInt(FeaturePolicySchema.CRITICALITY.toString(), 5);
        int cpuLimit = -1;
        int ramLimit = -1;
        int flashLimit = -1;
        if (rootObject.has(FeaturePolicySchema.RESOURCES.toString()) && rootObject.get(FeaturePolicySchema.RESOURCES.toString()) instanceof JSONObject && (resources = rootObject.getJSONObject(FeaturePolicySchema.RESOURCES.toString())).has(FeaturePolicySchema.LIMIT.toString()) && resources.get(FeaturePolicySchema.LIMIT.toString()) instanceof JSONObject) {
            JSONObject resourcesLimits = resources.getJSONObject(FeaturePolicySchema.LIMIT.toString());
            cpuLimit = resourcesLimits.optInt(FeaturePolicySchema.CPU.toString(), -1);
            ramLimit = resourcesLimits.optInt(FeaturePolicySchema.RAM.toString(), -1);
            flashLimit = resourcesLimits.optInt(FeaturePolicySchema.FLASH.toString(), -1);
        }
        if (rootObject.has(FeaturePolicySchema.NET_DATA.toString())) {
            JSONArray networkData = rootObject.getJSONObject(FeaturePolicySchema.NET_DATA.toString()).optJSONArray(FeaturePolicySchema.NET_UPSTREAM.toString());
            if (networkData == null) {
                networkData = new JSONArray();
                networkData.put((Object)rootObject.getJSONObject(FeaturePolicySchema.NET_DATA.toString()).getJSONObject(FeaturePolicySchema.NET_UPSTREAM.toString()));
            }
            int i = 0;
            while (i < networkData.length()) {
                JSONObject networkResources = networkData.getJSONObject(i);
                int networkBandwidthLimit = networkResources.optInt(FeaturePolicySchema.NET_LIMIT.toString(), -1);
                Bandwidth bandwidth = new Bandwidth(Bandwidth.Period.DAY, -1L, networkBandwidthLimit);
                String cidrSubnet = networkResources.optString(FeaturePolicySchema.NET_SUBNET.toString(), "0.0.0.0/0");
                Subnet subnet = Subnet.fromCidrNotation(cidrSubnet);
                this.applyNetworkBandwidthLimit(app, subnet, bandwidth);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "[Network " + i + "] Bandwidth: " + bandwidth);
                    LOGGER.log(Level.INFO, "[Network " + i + "] Subnet: " + subnet);
                }
                ++i;
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Threads priority: " + this.threadPriority);
            LOGGER.log(Level.INFO, "Feature criticality: " + criticality);
            LOGGER.log(Level.INFO, "CPU limit: " + cpuLimit);
            LOGGER.log(Level.INFO, "RAM limit: " + ramLimit);
            LOGGER.log(Level.INFO, "Flash limit: " + flashLimit);
        }
        this.applyCriticality(app, criticality);
        this.applyCpuLimits(app, cpuLimit);
        this.applyRamLimit(app, ramLimit);
        this.applyFlashLimit(app, flashLimit);
    }

    public void applyThreadPriority(Feature app) {
        int priority = this.threadPriority;
        if (priority == 5) {
            return;
        }
        if (priority < 1 || priority > 10) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Invalid priority: " + priority + ". Expected between " + 1 + " and " + 10 + ". Running with normal priority");
            }
            return;
        }
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            Module owner = Kernel.getOwner((Object)thread);
            if (!owner.equals(app)) continue;
            thread.setPriority(priority);
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.log(Level.INFO, "Thread name = " + thread.getName() + ", owner = " + owner.getName() + ", priority = " + thread.getPriority());
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Threads priority applied: " + priority);
        }
    }

    private void applyCriticality(Feature app, int criticality) {
        block6: {
            if (criticality == 5) {
                return;
            }
            if (criticality < 0 || criticality > 10) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Invalid criticality: " + criticality + ". Expected between " + 0 + " and " + 10 + ". Running with normal criticality");
                }
                return;
            }
            try {
                app.setCriticality(criticality);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Criticality applied: " + app.getCriticality());
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                LOGGER.log(Level.SEVERE, "Error while applying criticality", e);
            }
        }
    }

    private void applyCpuLimits(Feature app, int cpuLimit) {
        block4: {
            try {
                int quota = cpuLimit == -1 || cpuLimit == 0 ? cpuLimit : (int)((double)cpuLimit / 100.0 * (double)QUOTA_PERCENTAGE_RATIO);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "CPU quota computed: " + quota);
                }
                app.setExecutionQuota(quota);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "CPU quota applied: " + app.getExecutionQuota());
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, "Error while applying CPU limit", e);
            }
        }
    }

    private void applyRamLimit(Feature app, int ramLimit) {
        block5: {
            if (ramLimit == -1) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Skipping RAM limit");
                }
                return;
            }
            try {
                app.setMemoryLimit((long)ramLimit);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "RAM limit applied: " + app.getMemoryLimit());
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                LOGGER.log(Level.SEVERE, "Error while applying RAM limit", e);
            }
        }
    }

    private void applyFlashLimit(Feature app, int flashLimit) {
        SandboxedModuleHelper moduleManager = (SandboxedModuleHelper)ServiceFactory.getRequiredService(SandboxedModuleHelper.class);
        SandboxedModule sandboxedModule = moduleManager.getModule(app.getName());
        if (sandboxedModule != null) {
            FileSystemResourcesController fsController = sandboxedModule.getFileSystemResourceController();
            if (flashLimit > 0) {
                fsController.setMaxStorageSize(flashLimit);
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Flash limit applied: " + fsController.getMaxStorageSize());
            }
        }
    }

    private void applyNetworkBandwidthLimit(Feature app, Subnet subnet, Bandwidth maxBandwidth) {
        SandboxedModuleHelper moduleManager = (SandboxedModuleHelper)ServiceFactory.getRequiredService(SandboxedModuleHelper.class);
        SandboxedModule sandboxedModule = moduleManager.getModule(app.getName());
        if (sandboxedModule != null) {
            NetResourcesController netController = sandboxedModule.getNetworkResourceController();
            netController.setMaxBandwidth(subnet, maxBandwidth);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Network bandwidth applied");
            }
        }
    }
}

