/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.observable;

import ej.annotation.Nullable;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.observable.Observer;
import ej.observable.SimpleObservable;

public class KernelSimpleObservable
extends SimpleObservable {
    @Nullable
    private FeatureStateListener featureStateListener;

    public KernelSimpleObservable() {
        if (Kernel.getContextOwner() != Kernel.getInstance()) {
            throw new IllegalAccessError();
        }
        this.featureStateListener = new FeatureStateListener(){

            public void stateChanged(@Nullable Feature feature, @Nullable Feature.State previousState) {
                if (feature != null && feature.getState() == Feature.State.STOPPED) {
                    KernelSimpleObservable.this.unsetObserver((Module)feature);
                }
            }
        };
        Kernel.addFeatureStateListener((FeatureStateListener)this.featureStateListener);
    }

    public void dispose() {
        FeatureStateListener featureStateListener = this.featureStateListener;
        if (featureStateListener != null) {
            this.unsetObserver();
            Kernel.removeFeatureStateListener((FeatureStateListener)featureStateListener);
            this.featureStateListener = null;
        }
    }

    public void setObserver(Observer observer) {
        if (this.featureStateListener == null) {
            throw new IllegalStateException();
        }
        Kernel.enter();
        super.setObserver(observer);
    }

    private void unsetObserver(Module module) {
        Observer observer = this.getObserver();
        if (observer != null && Kernel.getOwner((Object)observer) == module) {
            this.unsetObserver(observer);
        }
    }
}

