/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.net;

import ej.bon.Timer;
import ej.bon.TimerTask;
import ej.bon.Util;
import ej.net.util.NtpUtil;
import ej.service.ServiceFactory;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NtpSyncTimerTask
extends TimerTask {
    private static final Logger LOGGER = Logger.getLogger("NTPUpdateTimerTask");
    private static final long NTP_THRESHOLD = 1563791681000L;
    private static final int NTP_RETRY_DELAY_MS = 15000;
    private static final int NTP_MAX_RETRY = 20;
    private static final long NTP_UPDATE_PERIOD_MS = 0x6DDD00L;
    private final String ntpUrl = System.getProperty("ntp.url", "0.pool.ntp.org");
    private final int ntpPort = Integer.getInteger("ntp.port", 123);
    private final int ntpTimeout = Integer.getInteger("ntp.timeout", 1000);
    private long retries = 0L;

    public void run() {
        Timer timer = (Timer)ServiceFactory.getRequiredService(Timer.class);
        if (this.updateTime()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Updated time: " + new Date(System.currentTimeMillis()));
                LOGGER.info("Scheduling a new time sync in 120 minutes");
            }
            timer.schedule((TimerTask)new NtpSyncTimerTask(), 0x6DDD00L);
        } else {
            ++this.retries;
            if (this.retries >= 20L) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Failed to update time after maximum retries");
                }
            } else {
                timer.schedule((TimerTask)new NtpSyncTimerTask(), 15000L * this.retries);
            }
        }
    }

    private boolean updateTime() {
        try {
            NtpUtil.updateLocalTime((String)this.ntpUrl, (int)this.ntpPort, (int)this.ntpTimeout);
            return Util.currentTimeMillis() > 1563791681000L;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Time update failed", e);
            }
            return false;
        }
    }
}

