/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.control.net;

import com.microej.kf.util.control.net.CloseSocket;
import com.microej.kf.util.control.net.WriteSocket;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class SocketOutputStream
extends FilterOutputStream {
    private final Socket socket;
    private static final Object lock = new Object();

    public SocketOutputStream(Socket socket, OutputStream outputstream) throws IOException {
        super(outputstream);
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Object object = lock;
        synchronized (object) {
            WriteSocket writeSocket = new WriteSocket(this.socket, 1);
            writeSocket.onStart();
            try {
                super.write(b);
                writeSocket.onEnd(true);
            }
            catch (IOException | IllegalArgumentException | SecurityException e) {
                writeSocket.onEnd(false);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = lock;
        synchronized (object) {
            WriteSocket writeSocket = new WriteSocket(this.socket, len);
            writeSocket.onStart();
            try {
                this.out.write(b, off, len);
                writeSocket.onEnd(true);
            }
            catch (IOException | IllegalArgumentException | SecurityException e) {
                writeSocket.onEnd(false);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = lock;
        synchronized (object) {
            boolean wasClosed = this.socket.isClosed();
            super.close();
            if (!wasClosed) {
                CloseSocket closeSocket = new CloseSocket(this.socket);
                closeSocket.onEnd(true);
            }
        }
    }
}

