/*
 * Java
 *
 * Copyright 2017-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.property;

import ej.kf.Kernel;
import ej.property.PropertyFactory;
import ej.property.SharedPropertyFactory;
import ej.property.loader.CompositePropertyLoader;
import ej.property.loader.FilePropertyLoader;
import ej.property.loader.SystemPropertyLoader;

/**
 * Defines the order of the property loading resolution:
 * <ol>
 * <li>the properties defined locally in the application or kernel.</li>
 * <li>the properties registered locally in the instance of property registry.</li>
 * <li>the properties shared in the instance of the shared registry.</li>
 * <li>the properties defined globally in the system properties.</li>
 * </ol>
 */

public class PropertyLoaderKF extends CompositePropertyLoader {

	private static final String PROPERTIES_PACKAGE = "/properties/"; //$NON-NLS-1$
	private static final String APPLICATION_PROPERTIES_LIST = ".properties"; //$NON-NLS-1$

	/**
	 * Creates the property loader.
	 */
	public PropertyLoaderKF() {
		String name = Kernel.getContextOwner().getName();
		addPropertyLoader(new FilePropertyLoader(PROPERTIES_PACKAGE + name + APPLICATION_PROPERTIES_LIST));
		addPropertyLoader(PropertyFactory.getPropertyRegistry());
		addPropertyLoader(SharedPropertyFactory.getSharedPropertyRegistry());
		addPropertyLoader(new SystemPropertyLoader());
	}
}
