/*
 * Java
 *
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */

package com.microej.kf.util.control.net;

import java.net.Socket;

/**
 * Abstract socket wrapper.
 */
public abstract class AbstractSocket {
	protected final Socket socket;

	/**
	 * Initializes a socket.
	 *
	 * @param socket
	 * 		the socket to initialize.
	 */
	protected AbstractSocket(Socket socket) {
		this.socket = socket;
	}

	/**
	 * Gets the socket.
	 *
	 * @return the socket.
	 */
	public Socket getSocket() {
		return this.socket;
	}

}
