/*
 * Java
 *
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */

package com.microej.kf.util.control.fs;

import java.io.File;

/**
 * Abstract file wrapper.
 */
public abstract class AbstractFile {

	protected final File file;

	/**
	 * Initializes a file.
	 *
	 * @param file
	 * 		the file to initialize.
	 */
	protected AbstractFile(File file) {
		this.file = file;
	}

	/**
	 * Gets the file.
	 *
	 * @return the file.
	 */
	public File getFile() {
		return this.file;
	}
}
