/*
 * Java
 *
 * Copyright 2015-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util;

import java.io.InputStream;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;
import ej.kf.Proxy;

public class InputStreamConverter implements Converter<InputStream> {

	@Override
	public InputStream convert(InputStream arg0, Feature arg1) throws IllegalAccessError {
		final Proxy<InputStream> ref = Kernel.newProxy(arg0, arg1);
		final InputStream[] result = new InputStream[1];
		Kernel.runUnderContext(arg1, new Runnable() {

			@Override
			public void run() {
				InputStreamProxy p = new InputStreamProxy(ref);
				Kernel.enter();
				result[0] = p;
			}
		});
		return result[0];
	}

	@Override
	public Class<InputStream> getType() {
		return InputStream.class;
	}

}