/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.paint;

import java.awt.geom.AffineTransform;

/**
 * Transformation visitor that concatenates an other affine transform.
 */
public class TransformationVisitor implements PaintVisitor {

	private final AffineTransform at;

	/**
	 * Creates a matrix transformer.
	 *
	 * @param at
	 *            the affine transform to apply
	 */
	public TransformationVisitor(AffineTransform at) {
		this.at = at;
	}

	@Override
	public AffineTransform visitTransform(AffineTransform at) {
		AffineTransform atTransform = (AffineTransform) this.at.clone();
		atTransform.concatenate(at);
		return atTransform;
	}

}
