/*
 * JACOB - CBOR implementation in Java.
 *
 * Copyright 2016-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 *
 * Licensed under Apache License v2.0.
 */
package ej.cbor;

/**
 *
 */
public abstract class ErrorMessage {

    public static final String PROP_ERROR_MESSAGE_IMPL = "ej.cbor.errormsg.impl";

    public static final int OUTPUT_STREAM_CANNOT_BE_NULL = 0;
    public static final int INVALID_ARRAY_LENGHT = 1;
    public static final int INVALID_MAP_LENGHT = 2;
    public static final int TAG_CANNOT_BE_NEGATIVE = 3;
    public static final int INPUT_STREAM_CANNOT_BE_NULL = 4;
    public static final int UNEXPECTED_BOOLEAN_VALUE = 5;
    public static final int INFINITE_LENGTH_BYTE_STRING_NOT_SUPPORTED = 6;
    public static final int STRING_LENGTH_TOO_LONG = 7;
    public static final int INFINITE_LENGHT_TEXT_STRING_NOT_SUPPORTED = 8;
    public static final int UNEXPECTED_TYPE = 9;
    public static final int UNEXPECTED_TYPE_TWO_TYPES = 10;
    public static final int UNEXPECTED_SUBTYPE = 11;
    public static final int NOT_WELL_FORMED_CBOR_INTEGER = 12;
    public static final int UNEXPECTED_PAYLOAD_OR_LENGTH = 13;
    public static final int NO_PAYLOAD = 14;
    public static final int ONE_BYTE = 15;
    public static final int TWO_BYTES = 16;
    public static final int FOUR_BYTES = 17;
    public static final int EIGHT_BYTES = 18;
    public static final int UNKNOWN = 19;
    public static final int INVALID_MAJOR_TYPE = 20;
    public static final int PARAMETERS_CANNOT_BE_NULL = 21;

    private static final ErrorMessage ERR;

    static {
        String impl = System.getProperty(ErrorMessage.PROP_ERROR_MESSAGE_IMPL);
        ErrorMessage tmp;
        if (impl != null) {
            try {
                tmp = (ErrorMessage) Class.forName(impl).newInstance();
            }
            catch (InstantiationException | IllegalAccessException | ClassNotFoundException e) {
                tmp = new ErrorMessageCode();
            }
        } else {
            tmp = new ErrorMessageCode();
        }
        ERR = tmp;
    }

    /**
     * Gets the default instance of {@link ErrorMessage}.
     * 
     * @return the default {@link ErrorMessage} instance.
     */
    public static ErrorMessage getDefault() {
        return ERR;
    }

    /**
     * Generates {@link String} for a specified error code.
     * 
     * @param errorCode the error code corresponding to the message.
     * @param args the optional list of arguments to construct the message {@link String}.
     * @return the error message {@link String}.
     */
    public abstract String messageAt(int errorCode, Object... args);

}
